/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateItemModelProvider;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class AssetLookup {
    public static ModelFile partialBaseModel(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, String ... suffix) {
        Object string = "/block";
        for (String suf : suffix) {
            string = (String)string + "_" + suf;
        }
        String location = "block/" + ctx.getName() + (String)string;
        return prov.models().getExistingFile(prov.modLoc(location));
    }

    public static ModelFile standardModel(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov) {
        return prov.models().getExistingFile(prov.modLoc("block/" + ctx.getName()));
    }

    public static <I extends BlockItem> ItemModelBuilder customItemModel(DataGenContext<Item, I> ctx, RegistrateItemModelProvider prov) {
        return prov.blockItem(() -> ((BlockItem)ctx.getEntry()).m_40614_(), "/item");
    }

    public static <I extends BlockItem> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> customBlockItemModel(String ... folders) {
        return (c, p) -> {
            Object path = "block";
            for (String string : folders) {
                path = (String)path + "/" + ("_".equals(string) ? c.getName() : string);
            }
            p.withExistingParent(c.getName(), p.modLoc((String)path));
        };
    }

    public static <I extends Item> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> customGenericItemModel(String ... folders) {
        return (c, p) -> {
            Object path = "block";
            for (String string : folders) {
                path = (String)path + "/" + ("_".equals(string) ? c.getName() : string);
            }
            p.withExistingParent(c.getName(), p.modLoc((String)path));
        };
    }

    public static Function<BlockState, ModelFile> forPowered(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? AssetLookup.partialBaseModel(ctx, prov, "powered") : AssetLookup.partialBaseModel(ctx, prov, new String[0]);
    }

    public static Function<BlockState, ModelFile> forPowered(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, String path) {
        return state -> prov.models().getExistingFile(prov.modLoc("block/" + path + ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? "_powered" : "")));
    }

    public static Function<BlockState, ModelFile> withIndicator(DataGenContext<?, ?> ctx, RegistrateBlockstateProvider prov, Function<BlockState, ModelFile> baseModelFunc, IntegerProperty property) {
        return state -> {
            ResourceLocation baseModel = ((ModelFile)baseModelFunc.apply((BlockState)state)).getLocation();
            Integer integer = (Integer)state.m_61143_((Property)property);
            return ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + integer, baseModel)).texture("indicator", "block/indicator/" + integer);
        };
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> existingItemModel() {
        return (c, p) -> p.getExistingFile(p.modLoc("item/" + c.getName()));
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> itemModel(String name) {
        return (c, p) -> p.getExistingFile(p.modLoc("item/" + name));
    }

    public static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> itemModelWithPartials() {
        return (c, p) -> p.withExistingParent("item/" + c.getName(), p.modLoc("item/" + c.getName() + "/item"));
    }
}

