/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.command.SConfigureConfigPacket;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.PacketDistributor;

public class ConfigCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"config").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SConfigureConfigPacket(SConfigureConfigPacket.Actions.configScreen.name(), ""));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"path", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SConfigureConfigPacket(SConfigureConfigPacket.Actions.configScreen.name(), StringArgumentType.getString((CommandContext)ctx, (String)"path")));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ConfigHelper.ConfigPath configPath;
            String path = StringArgumentType.getString((CommandContext)ctx, (String)"path");
            String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            try {
                configPath = ConfigHelper.ConfigPath.parse(path);
            }
            catch (IllegalArgumentException e) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent(e.getMessage()));
                return 0;
            }
            if (configPath.getType() == ModConfig.Type.CLIENT) {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
                AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SConfigureConfigPacket("SET" + path, value));
                return 1;
            }
            try {
                ConfigHelper.setConfigValue(configPath, value);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Great Success!"), false);
                return 1;
            }
            catch (ConfigHelper.InvalidValueException e) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Config could not be set the the specified value!"));
                return 0;
            }
            catch (Exception e) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Something went wrong while trying to set config value. Check the server logs for more information"));
                Create.LOGGER.warn("Exception during server-side config value set:", (Throwable)e);
                return 0;
            }
        }))));
    }
}

