/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.StringSerializableTrigger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.PlacedBlockTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AllAdvancements
implements DataProvider {
    static final String LANG = "advancement.create.";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public void register(Consumer<Advancement> t) {
        String id = "create";
        Advancement root = Advancement.Builder.m_138353_().m_138362_(AllItems.BRASS_HAND.asStack(), (Component)new TranslatableComponent("advancement.create.root"), (Component)new TranslatableComponent("advancement.create.root.desc"), new ResourceLocation("create", "textures/gui/advancements.png"), FrameType.TASK, false, false, false).m_138386_("0", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[0])).m_138389_(t, id + ":root");
        Advancement andesite_alloy = this.advancement("andesite_alloy", (ItemLike)AllItems.ANDESITE_ALLOY.get(), TaskType.NORMAL).m_138398_(root).m_138386_("0", (CriterionTriggerInstance)this.itemGathered((ItemLike)AllItems.ANDESITE_ALLOY.get())).m_138389_(t, id + ":andesite_alloy");
        this.kineticsBranch(t, andesite_alloy);
        Advancement aesthetics = this.advancement("aesthetics", (ItemLike)AllBlocks.WOODEN_BRACKET.get(), TaskType.NORMAL).m_138398_(andesite_alloy).m_138386_("0", AllTriggers.BRACKET_APPLY_TRIGGER.forEntries((Block[])new Block[]{(Block)AllBlocks.SHAFT.get()})).m_138386_("1", AllTriggers.BRACKET_APPLY_TRIGGER.forEntries((Block[])new Block[]{(Block)AllBlocks.COGWHEEL.get(), (Block)AllBlocks.LARGE_COGWHEEL.get()})).m_138386_("2", AllTriggers.BRACKET_APPLY_TRIGGER.forEntries((Block[])new Block[]{(Block)AllBlocks.FLUID_PIPE.get()})).m_138389_(t, id + ":aesthetics");
        Advancement reinforced = this.advancement("reinforced", (ItemLike)AllBlocks.ANDESITE_ENCASED_SHAFT.get(), TaskType.NORMAL).m_138398_(aesthetics).m_138386_("0", (CriterionTriggerInstance)AllTriggers.CASING_SHAFT.instance()).m_138386_("1", (CriterionTriggerInstance)AllTriggers.CASING_BELT.instance()).m_138386_("2", (CriterionTriggerInstance)AllTriggers.CASING_PIPE.instance()).m_138389_(t, id + ":reinforced");
        Advancement water_wheel = this.advancement("water_wheel", (ItemLike)AllBlocks.WATER_WHEEL.get(), TaskType.NORMAL).m_138398_(andesite_alloy).m_138386_("0", (CriterionTriggerInstance)this.placeBlock((Block)AllBlocks.WATER_WHEEL.get())).m_138386_("1", (CriterionTriggerInstance)AllTriggers.WATER_WHEEL.instance()).m_138389_(t, id + ":water_wheel");
        Advancement lava_wheel = this.advancement("lava_wheel", (ItemLike)Items.f_42448_, TaskType.SECRET).m_138398_(water_wheel).m_138386_("0", (CriterionTriggerInstance)AllTriggers.LAVA_WHEEL.instance()).m_138389_(t, id + ":lava_wheel");
        Advancement chocolate_wheel = this.advancement("chocolate_wheel", (ItemLike)((ForgeFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).m_6859_(), TaskType.SECRET).m_138398_(water_wheel).m_138386_("0", (CriterionTriggerInstance)AllTriggers.CHOCOLATE_WHEEL.instance()).m_138389_(t, id + ":chocolate_wheel");
        Advancement millstone = this.kinecticAdvancement("millstone", (Block)AllBlocks.MILLSTONE.get(), TaskType.NORMAL).m_138398_(andesite_alloy).m_138389_(t, id + ":millstone");
        Advancement cuckoo = this.advancement("cuckoo", (ItemLike)AllBlocks.CUCKOO_CLOCK.get(), TaskType.NORMAL).m_138398_(andesite_alloy).m_138386_("0", (CriterionTriggerInstance)AllTriggers.CUCKOO.instance()).m_138389_(t, id + ":cuckoo");
        Advancement windmill = this.advancement("windmill", (ItemLike)AllBlocks.WINDMILL_BEARING.get(), TaskType.NORMAL).m_138398_(andesite_alloy).m_138386_("0", (CriterionTriggerInstance)AllTriggers.WINDMILL.instance()).m_138389_(t, id + ":windmill");
        Advancement maxed_windmill = this.advancement("maxed_windmill", (ItemLike)AllBlocks.WINDMILL_BEARING.get(), TaskType.GOAL).m_138398_(windmill).m_138386_("0", (CriterionTriggerInstance)AllTriggers.MAXED_WINDMILL.instance()).m_138389_(t, id + ":maxed_windmill");
        Advancement andesite_casing = this.advancement("andesite_casing", (ItemLike)AllBlocks.ANDESITE_CASING.get(), TaskType.GOAL).m_138398_(andesite_alloy).m_138386_("0", (CriterionTriggerInstance)this.itemGathered((ItemLike)AllBlocks.ANDESITE_CASING.get())).m_138389_(t, id + ":andesite_casing");
        Advancement drill = this.kinecticAdvancement("mechanical_drill", (Block)AllBlocks.MECHANICAL_DRILL.get(), TaskType.NORMAL).m_138398_(andesite_casing).m_138389_(t, id + ":mechanical_drill");
        Advancement press = this.advancement("press", (ItemLike)AllBlocks.MECHANICAL_PRESS.get(), TaskType.MILESTONE).m_138398_(andesite_casing).m_138386_("0", (CriterionTriggerInstance)AllTriggers.BONK.instance()).m_138389_(t, id + ":press");
        Advancement fan = this.advancement("fan", (ItemLike)AllBlocks.ENCASED_FAN.get(), TaskType.NORMAL).m_138398_(press).m_138386_("0", AllTriggers.FAN_PROCESSING.forEntries((InWorldProcessing.Type[])new InWorldProcessing.Type[]{InWorldProcessing.Type.NONE})).m_138389_(t, id + ":fan");
        Advancement fan_lava = this.advancement("fan_lava", (ItemLike)Items.f_42448_, TaskType.NORMAL).m_138398_(fan).m_138386_("0", AllTriggers.FAN_PROCESSING.forEntries((InWorldProcessing.Type[])new InWorldProcessing.Type[]{InWorldProcessing.Type.BLASTING})).m_138389_(t, id + ":fan_lava");
        Advancement fan_smoke = this.advancement("fan_smoke", (ItemLike)Items.f_42781_, TaskType.NORMAL).m_138398_(fan).m_138386_("0", AllTriggers.FAN_PROCESSING.forEntries((InWorldProcessing.Type[])new InWorldProcessing.Type[]{InWorldProcessing.Type.SMOKING})).m_138389_(t, id + ":fan_smoke");
        Advancement fan_water = this.advancement("fan_water", (ItemLike)Items.f_42447_, TaskType.NORMAL).m_138398_(fan).m_138386_("0", AllTriggers.FAN_PROCESSING.forEntries((InWorldProcessing.Type[])new InWorldProcessing.Type[]{InWorldProcessing.Type.SPLASHING})).m_138389_(t, id + ":fan_water");
        Advancement rose_quartz = this.itemAdvancement("polished_rose_quartz", AllItems.POLISHED_ROSE_QUARTZ, TaskType.NORMAL).m_138398_(andesite_casing).m_138389_(t, id + ":polished_rose_quartz");
        Advancement electron_tube = this.itemAdvancement("electron_tube", AllItems.ELECTRON_TUBE, TaskType.NORMAL).m_138398_(rose_quartz).m_138389_(t, id + ":electron_tube");
        Advancement saw = this.kinecticAdvancement("mechanical_saw", (Block)AllBlocks.MECHANICAL_SAW.get(), TaskType.NORMAL).m_138398_(press).m_138389_(t, id + ":mechanical_saw");
        Advancement basin = this.advancement("basin", (ItemLike)AllBlocks.BASIN.get(), TaskType.NORMAL).m_138398_(press).m_138386_("0", (CriterionTriggerInstance)this.placeBlock((Block)AllBlocks.BASIN.get())).m_138386_("1", (CriterionTriggerInstance)AllTriggers.BASIN_THROW.instance()).m_138389_(t, id + ":basin");
        Advancement mixer = this.advancement("mixer", (ItemLike)AllBlocks.MECHANICAL_MIXER.get(), TaskType.MILESTONE).m_138386_("0", (CriterionTriggerInstance)this.placeBlock((Block)AllBlocks.MECHANICAL_MIXER.get())).m_138386_("1", (CriterionTriggerInstance)AllTriggers.MIXER_MIX.instance()).m_138398_(basin).m_138389_(t, id + ":mixer");
        Advancement compact = this.advancement("compact", (ItemLike)Blocks.f_50075_, TaskType.NORMAL).m_138386_("0", (CriterionTriggerInstance)AllTriggers.PRESS_COMPACT.instance()).m_138398_(basin).m_138389_(t, id + ":compact");
        Advancement blaze_burner = this.itemAdvancement("blaze_burner", AllBlocks.BLAZE_BURNER, TaskType.NORMAL).m_138398_(mixer).m_138389_(t, id + ":blaze_burner");
        Advancement brass = this.itemAdvancement("brass", AllItems.BRASS_INGOT, TaskType.NORMAL).m_138398_(blaze_burner).m_138389_(t, id + ":brass");
        this.brassAge(t, brass);
        this.copperAge(t, press);
    }

    void kineticsBranch(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement its_alive = this.advancement("its_alive", (ItemLike)AllBlocks.COGWHEEL.get(), TaskType.NORMAL).m_138398_(root).m_138386_("0", (CriterionTriggerInstance)AllTriggers.ROTATION.instance()).m_138389_(t, id + ":its_alive");
        Advancement belt = this.advancement("belt", (ItemLike)AllItems.BELT_CONNECTOR.get(), TaskType.NORMAL).m_138398_(its_alive).m_138386_("0", (CriterionTriggerInstance)AllTriggers.CONNECT_BELT.instance()).m_138389_(t, id + ":belt");
        Advancement tunnel = this.advancement("tunnel", (ItemLike)AllBlocks.ANDESITE_TUNNEL.get(), TaskType.NORMAL).m_138398_(belt).m_138386_("0", (CriterionTriggerInstance)AllTriggers.PLACE_TUNNEL.instance()).m_138389_(t, id + ":tunnel");
        Advancement splitter_tunnel = this.advancement("splitter_tunnel", (ItemLike)AllBlocks.BRASS_TUNNEL.get(), TaskType.MILESTONE).m_138398_(tunnel).m_138386_("0", (CriterionTriggerInstance)AllTriggers.CONNECT_TUNNEL.instance()).m_138389_(t, id + ":splitter_tunnel");
        Advancement chute = this.advancement("chute", (ItemLike)AllBlocks.CHUTE.get(), TaskType.NORMAL).m_138398_(belt).m_138386_("0", (CriterionTriggerInstance)this.placeBlock((Block)AllBlocks.CHUTE.get())).m_138389_(t, id + ":chute");
        Advancement upward_chute = this.advancement("upward_chute", (ItemLike)AllBlocks.ENCASED_FAN.get(), TaskType.NORMAL).m_138398_(chute).m_138386_("0", (CriterionTriggerInstance)AllTriggers.UPWARD_CHUTE.instance()).m_138389_(t, id + ":upward_chute");
        Advancement belt_funnel = this.advancement("belt_funnel", (ItemLike)AllBlocks.ANDESITE_FUNNEL.get(), TaskType.NORMAL).m_138398_(belt).m_138386_("0", (CriterionTriggerInstance)AllTriggers.BELT_FUNNEL.instance()).m_138389_(t, id + ":belt_funnel");
        Advancement belt_funnel_kiss = this.advancement("belt_funnel_kiss", (ItemLike)AllBlocks.BRASS_FUNNEL.get(), TaskType.SECRET).m_138398_(belt_funnel).m_138386_("0", (CriterionTriggerInstance)AllTriggers.BELT_FUNNEL_KISS.instance()).m_138389_(t, id + ":belt_funnel_kiss");
        Advancement wrench = this.itemAdvancement("wrench", AllItems.WRENCH, TaskType.NORMAL).m_138398_(its_alive).m_138389_(t, id + ":wrench");
        Advancement goggles = this.itemAdvancement("goggles", AllItems.GOGGLES, TaskType.NORMAL).m_138398_(its_alive).m_138389_(t, id + ":goggles");
        Advancement speed_gauge = this.kinecticAdvancement("speedometer", (Block)AllBlocks.SPEEDOMETER.get(), TaskType.NORMAL).m_138398_(goggles).m_138389_(t, id + ":speedometer");
        Advancement stress_gauge = this.kinecticAdvancement("stressometer", (Block)AllBlocks.STRESSOMETER.get(), TaskType.NORMAL).m_138398_(goggles).m_138389_(t, id + ":stressometer");
        Advancement shifting_gears = this.advancement("shifting_gears", (ItemLike)AllBlocks.LARGE_COGWHEEL.get(), TaskType.NORMAL).m_138398_(its_alive).m_138386_("0", (CriterionTriggerInstance)AllTriggers.SHIFTING_GEARS.instance()).m_138389_(t, id + ":shifting_gears");
        Advancement overstressed = this.advancement("overstressed", (ItemLike)Items.f_42127_, TaskType.SECRET).m_138398_(its_alive).m_138386_("0", (CriterionTriggerInstance)AllTriggers.OVERSTRESSED.instance()).m_138389_(t, id + ":overstressed");
    }

    void copperAge(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement copper_casing = this.advancement("copper_casing", (ItemLike)AllBlocks.COPPER_CASING.get(), TaskType.GOAL).m_138398_(root).m_138386_("0", (CriterionTriggerInstance)this.itemGathered((ItemLike)AllBlocks.COPPER_CASING.get())).m_138389_(t, id + ":copper_casing");
        Advancement item_drain = this.advancement("item_drain", (ItemLike)AllBlocks.ITEM_DRAIN.get(), TaskType.NORMAL).m_138398_(copper_casing).m_138386_("0", (CriterionTriggerInstance)AllTriggers.ITEM_DRAIN.instance()).m_138389_(t, id + ":item_drain");
        Advancement chained_item_drain = this.advancement("chained_item_drain", (ItemLike)AllBlocks.ITEM_DRAIN.get(), TaskType.SECRET).m_138398_(item_drain).m_138386_("0", (CriterionTriggerInstance)AllTriggers.CHAINED_ITEM_DRAIN.instance()).m_138389_(t, id + ":chained_item_drain");
        Advancement spout = this.advancement("spout", (ItemLike)AllBlocks.SPOUT.get(), TaskType.NORMAL).m_138398_(copper_casing).m_138386_("0", (CriterionTriggerInstance)AllTriggers.SPOUT.instance()).m_138389_(t, id + ":spout");
        Advancement spout_potion = this.advancement("spout_potion", (ItemLike)Items.f_42589_, TaskType.GOAL).m_138398_(spout).m_138386_("0", (CriterionTriggerInstance)AllTriggers.SPOUT_POTION.instance()).m_138389_(t, id + ":spout_potion");
        Advancement chocolate = this.itemAdvancement("chocolate", () -> ((ForgeFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).m_6859_(), TaskType.GOAL).m_138398_(spout).m_138389_(t, id + ":chocolate");
        Advancement glass_pipe = this.advancement("glass_pipe", (ItemLike)AllBlocks.FLUID_PIPE.get(), TaskType.NORMAL).m_138398_(copper_casing).m_138386_("0", (CriterionTriggerInstance)AllTriggers.GLASS_PIPE.instance()).m_138389_(t, id + ":glass_pipe");
        Advancement pipe_collision = this.advancement("pipe_collision", (ItemLike)AllBlocks.FLUID_VALVE.get(), TaskType.NORMAL).m_138398_(glass_pipe).m_138386_("0", (CriterionTriggerInstance)AllTriggers.PIPE_COLLISION.instance()).m_138389_(t, id + ":pipe_collision");
        Advancement pipe_spill = this.advancement("pipe_spill", (ItemLike)Items.f_42446_, TaskType.NORMAL).m_138398_(glass_pipe).m_138386_("0", (CriterionTriggerInstance)AllTriggers.PIPE_SPILL.instance()).m_138389_(t, id + ":pipe_spill");
        Advancement hose_pulley = this.advancement("hose_pulley", (ItemLike)AllBlocks.HOSE_PULLEY.get(), TaskType.NORMAL).m_138398_(pipe_spill).m_138386_("0", (CriterionTriggerInstance)AllTriggers.HOSE_PULLEY.instance()).m_138389_(t, id + ":hose_pulley");
        Advancement infinite_water = this.advancement("infinite_water", (ItemLike)Items.f_42447_, TaskType.NORMAL).m_138398_(hose_pulley).m_138386_("0", this.isInfinite(Fluids.f_76193_)).m_138389_(t, id + ":infinite_water");
        Advancement infinite_lava = this.advancement("infinite_lava", (ItemLike)Items.f_42448_, TaskType.GOAL).m_138398_(hose_pulley).m_138386_("0", this.isInfinite(Fluids.f_76195_)).m_138389_(t, id + ":infinite_lava");
        Advancement infinite_chocolate = this.advancement("infinite_chocolate", (ItemLike)((ForgeFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).m_6859_(), TaskType.CHALLENGE).m_138398_(hose_pulley).m_138386_("0", this.isInfinite((FlowingFluid)AllFluids.CHOCOLATE.get())).m_138389_(t, id + ":infinite_chocolate");
    }

    void brassAge(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement brass_casing = this.advancement("brass_casing", (ItemLike)AllBlocks.BRASS_CASING.get(), TaskType.GOAL).m_138398_(root).m_138386_("0", (CriterionTriggerInstance)this.itemGathered((ItemLike)AllBlocks.BRASS_CASING.get())).m_138389_(t, id + ":brass_casing");
        Advancement nixie_tube = this.advancement("nixie_tube", (ItemLike)AllBlocks.ORANGE_NIXIE_TUBE.get(), TaskType.NORMAL).m_138398_(brass_casing).m_138386_("0", (CriterionTriggerInstance)this.placeBlock((Block)AllBlocks.ORANGE_NIXIE_TUBE.get())).m_138389_(t, id + ":nixie_tube");
        Advancement crafter = this.kinecticAdvancement("crafter", (Block)AllBlocks.MECHANICAL_CRAFTER.get(), TaskType.MILESTONE).m_138398_(brass_casing).m_138389_(t, id + ":crafter");
        Advancement flywheel = this.advancement("flywheel", (ItemLike)AllBlocks.FLYWHEEL.get(), TaskType.NORMAL).m_138398_(crafter).m_138386_("0", (CriterionTriggerInstance)AllTriggers.FLYWHEEL.instance()).m_138389_(t, id + ":flywheel");
        Advancement overstress_flywheel = this.advancement("overstress_flywheel", (ItemLike)AllBlocks.FURNACE_ENGINE.get(), TaskType.CHALLENGE).m_138398_(flywheel).m_138386_("0", (CriterionTriggerInstance)AllTriggers.OVERSTRESS_FLYWHEEL.instance()).m_138389_(t, id + ":overstress_flywheel");
        Advancement clockwork_bearing = this.advancement("clockwork_bearing", (ItemLike)AllBlocks.CLOCKWORK_BEARING.get(), TaskType.NORMAL).m_138398_(brass_casing).m_138386_("0", (CriterionTriggerInstance)AllTriggers.CLOCKWORK_BEARING.instance()).m_138389_(t, id + ":clockwork_bearing");
        Advancement mechanical_arm = this.advancement("mechanical_arm", (ItemLike)AllBlocks.MECHANICAL_ARM.get(), TaskType.MILESTONE).m_138386_("0", (CriterionTriggerInstance)AllTriggers.MECHANICAL_ARM.instance()).m_138398_(brass_casing).m_138389_(t, id + ":mechanical_arm");
        Advancement musical_arm = this.advancement("musical_arm", (ItemLike)Items.f_42752_, TaskType.MILESTONE).m_138386_("0", (CriterionTriggerInstance)AllTriggers.MUSICAL_ARM.instance()).m_138398_(mechanical_arm).m_138389_(t, id + ":musical_arm");
        Advancement arm_many_targets = this.advancement("arm_many_targets", (ItemLike)AllBlocks.BRASS_FUNNEL.get(), TaskType.MILESTONE).m_138386_("0", (CriterionTriggerInstance)AllTriggers.ARM_MANY_TARGETS.instance()).m_138398_(mechanical_arm).m_138389_(t, id + ":arm_many_targets");
        Advancement arm_blaze_burner = this.advancement("arm_blaze_burner", (ItemLike)AllBlocks.BLAZE_BURNER.get(), TaskType.NORMAL).m_138386_("0", (CriterionTriggerInstance)AllTriggers.ARM_BLAZE_BURNER.instance()).m_138398_(mechanical_arm).m_138389_(t, id + ":arm_blaze_burner");
        Advancement deployer = this.kinecticAdvancement("deployer", (Block)AllBlocks.DEPLOYER.get(), TaskType.MILESTONE).m_138398_(brass_casing).m_138389_(t, id + ":deployer");
        Advancement clockwork_component = this.itemAdvancement("precision_mechanism", AllItems.PRECISION_MECHANISM, TaskType.NORMAL).m_138398_(deployer).m_138389_(t, id + ":precision_mechanism");
        Advancement clockwork_component_eob = this.deadEnd().m_138398_(clockwork_component).m_138386_("0", (CriterionTriggerInstance)this.itemGathered((ItemLike)AllItems.PRECISION_MECHANISM.get())).m_138389_(t, id + ":clockwork_component_eob");
        Advancement extendo_grip = this.advancement("extendo_grip", (ItemLike)AllItems.EXTENDO_GRIP.get(), TaskType.NORMAL).m_138398_(clockwork_component).m_138386_("0", (CriterionTriggerInstance)AllTriggers.EXTENDO.instance()).m_138389_(t, id + ":extendo_grip");
        Advancement potato_cannon = this.advancement("potato_cannon", (ItemLike)AllItems.POTATO_CANNON.get(), TaskType.GOAL).m_138398_(clockwork_component).m_138386_("0", (CriterionTriggerInstance)AllTriggers.POTATO_KILL.instance()).m_138389_(t, id + ":potato_cannon");
        Advancement dual_extendo_grip = this.advancement("dual_extendo_grip", (ItemLike)AllItems.EXTENDO_GRIP.get(), TaskType.SECRET).m_138398_(extendo_grip).m_138386_("0", (CriterionTriggerInstance)AllTriggers.GIGA_EXTENDO.instance()).m_138389_(t, id + ":dual_extendo_grip");
        Advancement speed_controller = this.kinecticAdvancement("speed_controller", (Block)AllBlocks.ROTATION_SPEED_CONTROLLER.get(), TaskType.NORMAL).m_138398_(clockwork_component).m_138389_(t, id + ":speed_controller");
        Advancement fist_bump = this.advancement("fist_bump", (ItemLike)AllBlocks.DEPLOYER.get(), TaskType.SECRET).m_138398_(deployer).m_138386_("0", (CriterionTriggerInstance)AllTriggers.DEPLOYER_BOOP.instance()).m_138389_(t, id + ":fist_bump");
        Advancement crushing_wheel = this.advancement("crushing_wheel", (ItemLike)AllBlocks.CRUSHING_WHEEL.get(), TaskType.MILESTONE).m_138398_(crafter).m_138386_("0", (CriterionTriggerInstance)this.itemGathered((ItemLike)AllBlocks.CRUSHING_WHEEL.get())).m_138389_(t, id + ":crushing_wheel");
        Advancement blaze_cake = this.itemAdvancement("blaze_cake", AllItems.BLAZE_CAKE, TaskType.NORMAL).m_138398_(crushing_wheel).m_138389_(t, id + ":blaze_cake");
        Advancement symmetry_wand = this.itemAdvancement("wand_of_symmetry", AllItems.WAND_OF_SYMMETRY, TaskType.NORMAL).m_138398_(clockwork_component).m_138389_(t, id + ":wand_of_symmetry");
    }

    public AllAdvancements(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.m_138327_());
            }
            Path path1 = AllAdvancements.getPath(path, p_204017_3_);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)p_204017_3_.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Create's Advancements";
    }

    public PlacedBlockTrigger.TriggerInstance placeBlock(Block block) {
        return PlacedBlockTrigger.TriggerInstance.m_59505_((Block)block);
    }

    public StringSerializableTrigger.Instance<Fluid> isInfinite(FlowingFluid fluid) {
        return AllTriggers.INFINITE_FLUID.forEntries((Fluid[])new Fluid[]{fluid.m_5613_()});
    }

    public InventoryChangeTrigger.TriggerInstance itemGathered(ItemLike itemprovider) {
        return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{itemprovider});
    }

    public Advancement.Builder kinecticAdvancement(String name, Block block, TaskType type) {
        return this.advancement(name, (ItemLike)block, type).m_138386_("0", (CriterionTriggerInstance)this.placeBlock(block));
    }

    public Advancement.Builder advancement(String name, ItemLike icon, TaskType type) {
        return this.advancement(name, new ItemStack(icon), type);
    }

    public Advancement.Builder deadEnd() {
        return this.advancement("eob", (ItemLike)Items.f_42799_, TaskType.SILENT_GATE);
    }

    public Advancement.Builder advancement(String name, ItemStack icon, TaskType type) {
        return Advancement.Builder.m_138353_().m_138362_(icon, (Component)new TranslatableComponent(LANG + name), (Component)new TranslatableComponent(LANG + name + ".desc"), null, type.frame, type.toast, type.announce, type.hide);
    }

    public Advancement.Builder itemAdvancement(String name, Supplier<? extends ItemLike> item, TaskType type) {
        return this.advancement(name, item.get(), type).m_138386_("0", (CriterionTriggerInstance)this.itemGathered(item.get()));
    }

    static enum TaskType {
        NORMAL(FrameType.TASK, true, false, false),
        MILESTONE(FrameType.TASK, true, true, false),
        GOAL(FrameType.GOAL, true, true, false),
        SECRET(FrameType.GOAL, true, true, true),
        SILENT_GATE(FrameType.CHALLENGE, false, false, false),
        CHALLENGE(FrameType.CHALLENGE, true, true, false);

        private FrameType frame;
        private boolean toast;
        private boolean announce;
        private boolean hide;

        private TaskType(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

