/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;

public class BookCopyAttribute
implements ItemAttribute {
    int generation;

    public BookCopyAttribute(int generation) {
        this.generation = generation;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.extractGeneration(itemStack) == this.generation;
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        int generation = this.extractGeneration(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (generation >= 0) {
            atts.add(new BookCopyAttribute(generation));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        switch (this.generation) {
            case 0: {
                return "book_copy_original";
            }
            case 1: {
                return "book_copy_first";
            }
            case 2: {
                return "book_copy_second";
            }
        }
        return "book_copy_tattered";
    }

    @Override
    public void writeNBT(CompoundTag nbt) {
        nbt.m_128405_("generation", this.generation);
    }

    @Override
    public ItemAttribute readNBT(CompoundTag nbt) {
        return new BookCopyAttribute(nbt.m_128451_("generation"));
    }

    private int extractGeneration(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && stack.m_41720_() instanceof WrittenBookItem) {
            return nbt.m_128451_("generation");
        }
        return -1;
    }
}

