/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.logistics.block.redstone.ContentObserverBlock;
import com.simibubi.create.content.logistics.block.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.TankManipulationBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ContentObserverTileEntity
extends SmartTileEntity {
    private static final int DEFAULT_DELAY = 6;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    public int turnOffTicks = 0;

    public ContentObserverTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot()).moveText(new Vec3(0.0, 5.0, 0.0));
        behaviours.add(this.filtering);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = CapManipulationBehaviourBase.InterfaceProvider.towardBlockFacing();
        this.observedInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    @Override
    public void tick() {
        super.tick();
        BlockState state = this.m_58900_();
        if (this.turnOffTicks > 0) {
            --this.turnOffTicks;
            if (this.turnOffTicks == 0) {
                this.f_58857_.m_186460_(this.f_58858_, state.m_60734_(), 1);
            }
        }
        if (!this.isActive()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)ContentObserverBlock.f_54117_);
        BlockPos targetPos = this.f_58858_.m_142300_(facing);
        TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)this.f_58857_, targetPos, TransportedItemStackHandlerBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.handleCenteredProcessingOnAllItems(0.45f, stack -> {
                if (!this.filtering.test(stack.stack) || this.turnOffTicks == 6) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                this.activate();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
            return;
        }
        FluidTransportBehaviour fluidBehaviour = TileEntityBehaviour.get((BlockGetter)this.f_58857_, targetPos, FluidTransportBehaviour.TYPE);
        if (fluidBehaviour != null) {
            for (Direction side : Iterate.directions) {
                PipeConnection.Flow flow = fluidBehaviour.getFlow(side);
                if (flow == null || !flow.inbound || !flow.complete || !this.filtering.test(flow.fluid)) continue;
                this.activate();
                return;
            }
            return;
        }
        if (!((InvManipulationBehaviour)this.observedInventory.simulate()).extract().m_41619_()) {
            this.activate();
            return;
        }
        if (!((TankManipulationBehaviour)this.observedTank.simulate()).extractAny().isEmpty()) {
            this.activate();
            return;
        }
    }

    public void activate() {
        this.activate(6);
    }

    public void activate(int ticks) {
        BlockState state = this.m_58900_();
        this.turnOffTicks = ticks;
        if (((Boolean)state.m_61143_((Property)ContentObserverBlock.POWERED)).booleanValue()) {
            return;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)ContentObserverBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }

    private boolean isActive() {
        return true;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("TurnOff", this.turnOffTicks);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.turnOffTicks = compound.m_128451_("TurnOff");
    }
}

