/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.Rotate;
import com.jozufozu.flywheel.util.transform.Translate;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverBlock;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class AnalogLeverInstance
extends BlockEntityInstance<AnalogLeverTileEntity>
implements DynamicInstance {
    protected final ModelData handle;
    protected final ModelData indicator;
    final float rX;
    final float rY;

    public AnalogLeverInstance(MaterialManager modelManager, AnalogLeverTileEntity tile) {
        super(modelManager, (BlockEntity)tile);
        Material mat = this.getTransformMaterial();
        this.handle = (ModelData)mat.getModel(AllBlockPartials.ANALOG_LEVER_HANDLE, this.blockState).createInstance();
        this.indicator = (ModelData)mat.getModel(AllBlockPartials.ANALOG_LEVER_INDICATOR, this.blockState).createInstance();
        this.transform(this.indicator);
        AttachFace face = (AttachFace)this.blockState.m_61143_((Property)AnalogLeverBlock.f_53179_);
        this.rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        this.rY = AngleHelper.horizontalAngle((Direction)this.blockState.m_61143_((Property)AnalogLeverBlock.f_54117_));
        this.animateLever();
    }

    public void beginFrame() {
        if (!((AnalogLeverTileEntity)this.blockEntity).clientState.settled()) {
            this.animateLever();
        }
    }

    protected void animateLever() {
        float state = ((AnalogLeverTileEntity)this.blockEntity).clientState.get(AnimationTickHolder.getPartialTicks());
        this.indicator.setColor(Color.mixColors(2884352, 0xCD0000, state / 15.0f));
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        ((ModelData)this.transform(this.handle.loadIdentity()).translate(0.5, 0.0625, 0.5).rotate(Direction.EAST, angle)).translate(-0.5, -0.0625, -0.5);
    }

    public void remove() {
        this.handle.delete();
        this.indicator.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.handle, this.indicator});
    }

    private <T extends Translate<T> & Rotate<T>> T transform(T msr) {
        return (T)((Translate)((Translate)((Rotate)((Translate)((Rotate)((Translate)((Translate)msr.translate((Vec3i)this.getInstancePosition())).centre())).rotate(Direction.UP, (float)((double)(this.rY / 180.0f) * Math.PI)))).rotate(Direction.EAST, (float)((double)(this.rX / 180.0f) * Math.PI))).unCentre());
    }
}

