/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.curiosities.bell.AbstractBellTileEntity;
import com.simibubi.create.foundation.block.ITE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractBellBlock<TE extends AbstractBellTileEntity>
extends BellBlock
implements ITE<TE> {
    public AbstractBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext selection) {
        Direction facing = (Direction)state.m_61143_((Property)f_49679_);
        switch ((BellAttachType)state.m_61143_((Property)f_49680_)) {
            case CEILING: {
                return AllShapes.BELL_CEILING.get(facing);
            }
            case DOUBLE_WALL: {
                return AllShapes.BELL_DOUBLE_WALL.get(facing);
            }
            case FLOOR: {
                return AllShapes.BELL_FLOOR.get(facing);
            }
            case SINGLE_WALL: {
                return AllShapes.BELL_WALL.get(facing);
            }
        }
        return Shapes.m_83144_();
    }

    public boolean m_49701_(Level world, BlockState state, BlockHitResult hit, @Nullable Player player, boolean flag) {
        BlockPos pos = hit.m_82425_();
        Direction direction = hit.m_82434_();
        if (direction == null) {
            direction = (Direction)world.m_8055_(pos).m_61143_((Property)f_49679_);
        }
        if (!this.canRingFrom(state, direction, hit.m_82450_().f_82480_ - (double)pos.m_123342_())) {
            return false;
        }
        AbstractBellTileEntity te = (AbstractBellTileEntity)this.getTileEntity((BlockGetter)world, pos);
        if (te == null || !te.ring(world, pos, direction)) {
            return false;
        }
        if (!world.f_46443_) {
            this.playSound(world, pos);
            if (player != null) {
                player.m_36220_(Stats.f_12979_);
            }
        }
        return true;
    }

    public boolean canRingFrom(BlockState state, Direction hitDir, double heightChange) {
        if (hitDir.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        if (heightChange > 0.8124) {
            return false;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_49679_);
        BellAttachType bellAttachment = (BellAttachType)state.m_61143_((Property)f_49680_);
        switch (bellAttachment) {
            case CEILING: 
            case FLOOR: {
                return direction.m_122434_() == hitDir.m_122434_();
            }
            case DOUBLE_WALL: 
            case SINGLE_WALL: {
                return direction.m_122434_() != hitDir.m_122434_();
            }
        }
        return false;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos p_152198_, BlockState p_152199_) {
        return ITE.super.m_142194_(p_152198_, p_152199_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152194_, BlockState p_152195_, BlockEntityType<T> p_152196_) {
        return ITE.super.m_142354_(p_152194_, p_152195_, p_152196_);
    }

    public abstract void playSound(Level var1, BlockPos var2);
}

