/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class StressGaugeTileEntity
extends GaugeTileEntity {
    public StressGaugeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? 0.0f : (this.isOverStressed() ? 1.125f : (maxStress == 0.0f ? 0.0f : currentStress / maxStress));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? Color.mixColors(65280, 0xFFFF00, this.dialTarget * 2.0f) : (this.dialTarget < 1.0f ? Color.mixColors(0xFFFF00, 0xFF0000, this.dialTarget * 2.0f - 1.0f) : 0xFF0000);
        }
        this.sendData();
        this.m_6596_();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.dialTarget = 0.0f;
            this.m_6596_();
            return;
        }
        this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = this.getNetworkCapacity();
        double stressFraction = (double)this.getNetworkStress() / (capacity == 0.0 ? 1.0 : capacity);
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("gui.stressometer.title", new Object[0]).m_130940_(ChatFormatting.GRAY)));
        if (this.getTheoreticalSpeed() == 0.0f) {
            tooltip.add((Component)new TextComponent("    " + ItemDescription.makeProgressBar(3, 0)).m_7220_((Component)Lang.translate("gui.stressometer.no_rotation", new Object[0])).m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_(IRotate.StressImpact.getFormattedStressText(stressFraction)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("gui.stressometer.capacity", new Object[0]).m_130940_(ChatFormatting.GRAY)));
            double remainingCapacity = capacity - (double)this.getNetworkStress();
            TranslatableComponent su = Lang.translate("generic.unit.stress", new Object[0]);
            MutableComponent stressTooltip = componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + IHaveGoggleInformation.format(remainingCapacity)).m_7220_((Component)su.m_6879_()).m_130940_(IRotate.StressImpact.of(stressFraction).getRelativeColor()));
            if (remainingCapacity != capacity) {
                stressTooltip.m_7220_((Component)new TextComponent(" / ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(IHaveGoggleInformation.format(capacity)).m_7220_((Component)su.m_6879_()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            tooltip.add((Component)stressTooltip);
        }
        return true;
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }
}

