/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.foundation.block.render.QuadHelper;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;

public class BeltModel
extends BakedModelWrapper<BakedModel> {
    public BeltModel(BakedModel template) {
        super(template);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData);
        if (!extraData.hasProperty(BeltTileEntity.CASING_PROPERTY)) {
            return quads;
        }
        BeltTileEntity.CasingType type = (BeltTileEntity.CasingType)((Object)extraData.getData(BeltTileEntity.CASING_PROPERTY));
        if (type == BeltTileEntity.CasingType.NONE || type == BeltTileEntity.CasingType.BRASS) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        SpriteShiftEntry spriteShift = AllSpriteShifts.ANDESIDE_BELT_CASING;
        VertexFormat format = DefaultVertexFormat.f_85811_;
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            if (spriteShift == null || quad.m_173410_() != spriteShift.getOriginal()) continue;
            TextureAtlasSprite original = quad.m_173410_();
            TextureAtlasSprite target = spriteShift.getTarget();
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < vertexData.length; vertex += format.m_86017_()) {
                int uvOffset = 4;
                int uIndex = vertex + uvOffset;
                int vIndex = vertex + uvOffset + 1;
                float u = Float.intBitsToFloat(vertexData[uIndex]);
                float v = Float.intBitsToFloat(vertexData[vIndex]);
                vertexData[uIndex] = Float.floatToRawIntBits(target.m_118367_((double)SuperByteBuffer.getUnInterpolatedU(original, u)));
                vertexData[vIndex] = Float.floatToRawIntBits(target.m_118393_((double)SuperByteBuffer.getUnInterpolatedV(original, v)));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

