/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.fluids.actors.SpoutTileEntity;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public class SpoutRenderer
extends SafeTileEntityRenderer<SpoutTileEntity> {
    static final PartialModel[] BITS = new PartialModel[]{AllBlockPartials.SPOUT_TOP, AllBlockPartials.SPOUT_MIDDLE, AllBlockPartials.SPOUT_BOTTOM};

    public SpoutRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(SpoutTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SmartFluidTankBehaviour tank = te.tank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            level = Math.max(level, 0.175f);
            float min = 0.15625f;
            float max = min + 0.6875f;
            float yOffset = 0.6875f * level;
            ms.m_85836_();
            ms.m_85837_(0.0, (double)yOffset, 0.0);
            FluidRenderer.renderFluidBox(fluidStack, min, min - yOffset, min, max, min, max, buffer, ms, light, false);
            ms.m_85849_();
        }
        int processingTicks = te.processingTicks;
        float processingPT = (float)processingTicks - partialTicks;
        float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
        processingProgress = Mth.m_14036_((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = 0.0f;
        if (processingTicks != -1) {
            radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
            AABB bb = new AABB(0.5, 0.5, 0.5, 0.5, -1.2, 0.5).m_82400_((double)(radius / 32.0f));
            FluidRenderer.renderFluidBox(fluidStack, (float)bb.f_82288_, (float)bb.f_82289_, (float)bb.f_82290_, (float)bb.f_82291_, (float)bb.f_82292_, (float)bb.f_82293_, buffer, ms, light, true);
        }
        float squeeze = radius;
        if (processingPT < 0.0f) {
            squeeze = 0.0f;
        } else if (processingPT < 2.0f) {
            squeeze = Mth.m_14179_((float)(processingPT / 2.0f), (float)0.0f, (float)-1.0f);
        } else if (processingPT < 10.0f) {
            squeeze = -1.0f;
        }
        ms.m_85836_();
        for (PartialModel bit : BITS) {
            CachedBufferer.partial(bit, te.m_58900_()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            ms.m_85837_(0.0, (double)(-3.0f * squeeze / 32.0f), 0.0);
        }
        ms.m_85849_();
    }
}

