/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ChassisRangeDisplay {
    private static final int DISPLAY_TIME = 200;
    private static GroupEntry lastHoveredGroup = null;
    static Map<BlockPos, Entry> entries = new HashMap<BlockPos, Entry>();
    static List<GroupEntry> groupEntries = new ArrayList<GroupEntry>();

    public static void tick() {
        GroupEntry existingGroupForPos;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        boolean hasWrench = AllItems.WRENCH.isIn(player.m_21205_());
        Iterator<Object> iterator = entries.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            Entry entry = entries.get(pos);
            if (ChassisRangeDisplay.tickEntry(entry, hasWrench)) {
                iterator.remove();
            }
            CreateClient.OUTLINER.keep(entry.getOutlineKey());
        }
        iterator = groupEntries.iterator();
        while (iterator.hasNext()) {
            GroupEntry group = (GroupEntry)iterator.next();
            if (ChassisRangeDisplay.tickEntry(group, hasWrench)) {
                iterator.remove();
                if (group == lastHoveredGroup) {
                    lastHoveredGroup = null;
                }
            }
            CreateClient.OUTLINER.keep(group.getOutlineKey());
        }
        if (!hasWrench) {
            return;
        }
        HitResult over = Minecraft.m_91087_().f_91077_;
        if (!(over instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult ray = (BlockHitResult)over;
        BlockPos pos = ray.m_82425_();
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity == null || tileEntity.m_58901_()) {
            return;
        }
        if (!(tileEntity instanceof ChassisTileEntity)) {
            return;
        }
        boolean ctrl = AllKeys.ctrlDown();
        ChassisTileEntity chassisTileEntity = (ChassisTileEntity)tileEntity;
        if (ctrl && (existingGroupForPos = ChassisRangeDisplay.getExistingGroupForPos(pos)) != null) {
            for (ChassisTileEntity included : existingGroupForPos.includedTEs) {
                entries.remove(included.m_58899_());
            }
            existingGroupForPos.timer = 200;
            return;
        }
        if (!entries.containsKey(pos) || ctrl) {
            ChassisRangeDisplay.display(chassisTileEntity);
        } else if (!ctrl) {
            ChassisRangeDisplay.entries.get((Object)pos).timer = 200;
        }
    }

    private static boolean tickEntry(Entry entry, boolean hasWrench) {
        ChassisTileEntity chassisTileEntity = entry.te;
        Level teWorld = chassisTileEntity.m_58904_();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (chassisTileEntity.m_58901_() || teWorld == null || teWorld != world || !world.m_46749_(chassisTileEntity.m_58899_())) {
            return true;
        }
        if (!hasWrench && entry.timer > 20) {
            entry.timer = 20;
            return false;
        }
        --entry.timer;
        return entry.timer == 0;
    }

    public static void display(ChassisTileEntity chassis) {
        if (AllKeys.ctrlDown()) {
            GroupEntry hoveredGroup = new GroupEntry(chassis);
            for (ChassisTileEntity included : hoveredGroup.includedTEs) {
                CreateClient.OUTLINER.remove(included.m_58899_());
            }
            groupEntries.forEach(entry -> CreateClient.OUTLINER.remove(entry.getOutlineKey()));
            groupEntries.clear();
            entries.clear();
            groupEntries.add(hoveredGroup);
            return;
        }
        BlockPos pos = chassis.m_58899_();
        GroupEntry entry2 = ChassisRangeDisplay.getExistingGroupForPos(pos);
        if (entry2 != null) {
            CreateClient.OUTLINER.remove(entry2.getOutlineKey());
        }
        groupEntries.clear();
        entries.clear();
        entries.put(pos, new Entry(chassis));
    }

    private static GroupEntry getExistingGroupForPos(BlockPos pos) {
        for (GroupEntry groupEntry : groupEntries) {
            for (ChassisTileEntity chassis : groupEntry.includedTEs) {
                if (!pos.equals((Object)chassis.m_58899_())) continue;
                return groupEntry;
            }
        }
        return null;
    }

    private static class Entry {
        ChassisTileEntity te;
        int timer;

        public Entry(ChassisTileEntity te) {
            this.te = te;
            this.timer = 200;
            CreateClient.OUTLINER.showCluster(this.getOutlineKey(), this.createSelection(te)).colored(0xFFFFFF).disableNormals().lineWidth(0.0625f).withFaceTexture(AllSpecialTextures.HIGHLIGHT_CHECKERED);
        }

        protected Object getOutlineKey() {
            return Pair.of((Object)this.te.m_58899_(), (Object)1);
        }

        protected Set<BlockPos> createSelection(ChassisTileEntity chassis) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(null, true);
            if (includedBlockPositions == null) {
                return Collections.emptySet();
            }
            positions.addAll(includedBlockPositions);
            return positions;
        }
    }

    private static class GroupEntry
    extends Entry {
        List<ChassisTileEntity> includedTEs;

        public GroupEntry(ChassisTileEntity te) {
            super(te);
        }

        @Override
        protected Object getOutlineKey() {
            return this;
        }

        @Override
        protected Set<BlockPos> createSelection(ChassisTileEntity chassis) {
            HashSet<BlockPos> list = new HashSet<BlockPos>();
            this.includedTEs = this.te.collectChassisGroup();
            if (this.includedTEs == null) {
                return list;
            }
            for (ChassisTileEntity chassisTileEntity : this.includedTEs) {
                list.addAll(super.createSelection(chassisTileEntity));
            }
            return list;
        }
    }
}

