/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.ContraptionBlockSource;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenseItemLocation;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DropperMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.IMovedDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedProjectileDispenserBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.mixin.accessor.DispenserBlockAccessor;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DispenserMovementBehaviour
extends DropperMovementBehaviour {
    private static final HashMap<Item, IMovedDispenseItemBehaviour> MOVED_DISPENSE_ITEM_BEHAVIOURS = new HashMap();
    private static final HashMap<Item, IMovedDispenseItemBehaviour> MOVED_PROJECTILE_DISPENSE_BEHAVIOURS = new HashMap();
    private static boolean spawnEggsRegistered = false;

    public static void gatherMovedDispenseItemBehaviours() {
        IMovedDispenseItemBehaviour.init();
    }

    public static void registerMovedDispenseItemBehaviour(Item item, IMovedDispenseItemBehaviour movedDispenseItemBehaviour) {
        MOVED_DISPENSE_ITEM_BEHAVIOURS.put(item, movedDispenseItemBehaviour);
    }

    public static DispenseItemBehavior getDispenseMethod(ItemStack itemstack) {
        return ((DispenserBlockAccessor)Blocks.f_50061_).create$callGetDispenseMethod(itemstack);
    }

    @Override
    protected void activate(MovementContext context, BlockPos pos) {
        DispenseItemLocation location;
        if (!spawnEggsRegistered) {
            spawnEggsRegistered = true;
            IMovedDispenseItemBehaviour.initSpawnEggs();
        }
        if ((location = this.getDispenseLocation(context)).isEmpty()) {
            context.world.m_46796_(1001, pos, 0);
        } else {
            ItemStack itemStack = this.getItemStackAt(location, context);
            if (MOVED_DISPENSE_ITEM_BEHAVIOURS.containsKey(itemStack.m_41720_())) {
                this.setItemStackAt(location, MOVED_DISPENSE_ITEM_BEHAVIOURS.get(itemStack.m_41720_()).dispense(itemStack, context, pos), context);
                return;
            }
            ItemStack backup = itemStack.m_41777_();
            try {
                if (MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.containsKey(itemStack.m_41720_())) {
                    this.setItemStackAt(location, MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.get(itemStack.m_41720_()).dispense(itemStack, context, pos), context);
                    return;
                }
                DispenseItemBehavior behavior = DispenserMovementBehaviour.getDispenseMethod(itemStack);
                if (behavior instanceof AbstractProjectileDispenseBehavior) {
                    MovedProjectileDispenserBehaviour movedBehaviour = MovedProjectileDispenserBehaviour.of((AbstractProjectileDispenseBehavior)behavior);
                    this.setItemStackAt(location, movedBehaviour.dispense(itemStack, context, pos), context);
                    MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.put(itemStack.m_41720_(), movedBehaviour);
                    return;
                }
                Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)DispenserBlock.f_52659_)).m_122436_());
                facingVec = (Vec3)context.rotation.apply(facingVec);
                facingVec.m_82541_();
                Direction clostestFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
                ContraptionBlockSource blockSource = new ContraptionBlockSource(context, pos, clostestFacing);
                if (behavior.getClass() != DefaultDispenseItemBehavior.class) {
                    this.setItemStackAt(location, behavior.m_6115_((BlockSource)blockSource, itemStack), context);
                    return;
                }
            }
            catch (NullPointerException ignored) {
                itemStack = backup;
            }
            this.setItemStackAt(location, DEFAULT_BEHAVIOUR.dispense(itemStack, context, pos), context);
        }
    }
}

