/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public abstract class ProcessingViaFanCategory<T extends Recipe<?>>
extends CreateRecipeCategory<T> {
    protected static final int SCALE = 24;

    public ProcessingViaFanCategory(IDrawable icon) {
        this(178, icon);
    }

    public ProcessingViaFanCategory(int width, IDrawable icon) {
        super(icon, ProcessingViaFanCategory.emptyBackground(width, 72));
    }

    public static Supplier<ItemStack> getFan(String name) {
        return () -> AllBlocks.ENCASED_FAN.asStack().m_41714_((Component)Lang.translate("recipe." + name + ".fan", new Object[0]).m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
    }

    public void setIngredients(T recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, T recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 20, 47);
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.init(1, false, 140, 47);
        itemStacks.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(T recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        this.renderWidgets(matrixStack, recipe, mouseX, mouseY);
        matrixStack.m_85836_();
        this.translateFan(matrixStack);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-12.5f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(22.5f));
        AnimatedKinetics.defaultBlockElement(AllBlockPartials.ENCASED_FAN_INNER).rotateBlock(180.0, 0.0, AnimatedKinetics.getCurrentAngle() * 16.0f).scale(24.0).render(matrixStack);
        AnimatedKinetics.defaultBlockElement(AllBlocks.ENCASED_FAN.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale(24.0).render(matrixStack);
        this.renderAttachedBlock(matrixStack);
        matrixStack.m_85849_();
    }

    protected void renderWidgets(PoseStack matrixStack, T recipe, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 46, 29);
        this.getBlockShadow().render(matrixStack, 65, 39);
        AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 54, 51);
        AllGuiTextures.JEI_SLOT.render(matrixStack, 20, 47);
        AllGuiTextures.JEI_SLOT.render(matrixStack, 140, 47);
    }

    protected AllGuiTextures getBlockShadow() {
        return AllGuiTextures.JEI_SHADOW;
    }

    protected void translateFan(PoseStack matrixStack) {
        matrixStack.m_85837_(56.0, 33.0, 0.0);
    }

    protected abstract void renderAttachedBlock(PoseStack var1);

    public static abstract class MultiOutput<T extends ProcessingRecipe<?>>
    extends ProcessingViaFanCategory<T> {
        public MultiOutput(IDrawable icon) {
            super(icon);
        }

        public MultiOutput(int width, IDrawable icon) {
            super(width, icon);
        }

        @Override
        public void setIngredients(T recipe, IIngredients ingredients) {
            ingredients.setInputIngredients(((ProcessingRecipe)recipe).m_7527_());
            ingredients.setOutputs(VanillaTypes.ITEM, ((ProcessingRecipe)recipe).getRollableResultsAsItemStacks());
        }

        @Override
        public void setRecipe(IRecipeLayout recipeLayout, T recipe, IIngredients ingredients) {
            IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
            NonNullList<ProcessingOutput> results = ((ProcessingRecipe)recipe).getRollableResults();
            int xOffsetAmount = 1 - Math.min(3, results.size());
            itemStacks.init(0, true, 5 * xOffsetAmount + 20, 47);
            itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            int xOffsetOutput = 9 * xOffsetAmount;
            boolean excessive = results.size() > 9;
            for (int outputIndex = 0; outputIndex < results.size(); ++outputIndex) {
                int xOffset = outputIndex % 3 * 19 + xOffsetOutput;
                int yOffset = outputIndex / 3 * -19 + (excessive ? 8 : 0);
                itemStacks.init(outputIndex + 1, false, 140 + xOffset, 47 + yOffset);
                itemStacks.set(outputIndex + 1, ((ProcessingOutput)results.get(outputIndex)).getStack());
            }
            MultiOutput.addStochasticTooltip(itemStacks, results);
        }

        @Override
        protected void renderWidgets(PoseStack matrixStack, T recipe, double mouseX, double mouseY) {
            int size = ((ProcessingRecipe)recipe).getRollableResultsAsItemStacks().size();
            int xOffsetAmount = 1 - Math.min(3, size);
            AllGuiTextures.JEI_SHADOW.render(matrixStack, 46, 29);
            this.getBlockShadow().render(matrixStack, 65, 39);
            AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 7 * xOffsetAmount + 54, 51);
            AllGuiTextures.JEI_SLOT.render(matrixStack, 5 * xOffsetAmount + 20, 47);
            int xOffsetOutput = 9 * xOffsetAmount;
            boolean excessive = size > 9;
            for (int i = 0; i < size; ++i) {
                int xOffset = i % 3 * 19 + xOffsetOutput;
                int yOffset = i / 3 * -19 + (excessive ? 8 : 0);
                MultiOutput.getRenderedSlot(recipe, i).render(matrixStack, 140 + xOffset, 47 + yOffset);
            }
        }
    }
}

