/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.deployer.DeployerMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.LeverMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.TrapdoorMovingInteraction;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class AllInteractionBehaviours {
    private static final HashMap<ResourceLocation, Supplier<MovingInteractionBehaviour>> INTERACT_BEHAVIOURS = new HashMap();

    public static void addInteractionBehaviour(ResourceLocation loc, Supplier<MovingInteractionBehaviour> behaviour) {
        if (INTERACT_BEHAVIOURS.containsKey(loc)) {
            Create.LOGGER.warn("Interaction behaviour for " + loc.toString() + " was overridden");
        }
        INTERACT_BEHAVIOURS.put(loc, behaviour);
    }

    public static void addInteractionBehaviour(Block block, Supplier<MovingInteractionBehaviour> behaviour) {
        AllInteractionBehaviours.addInteractionBehaviour(block.getRegistryName(), behaviour);
    }

    @Nullable
    public static MovingInteractionBehaviour of(ResourceLocation loc) {
        return INTERACT_BEHAVIOURS.get(loc) == null ? null : INTERACT_BEHAVIOURS.get(loc).get();
    }

    @Nullable
    public static MovingInteractionBehaviour of(Block block) {
        return AllInteractionBehaviours.of(block.getRegistryName());
    }

    public static boolean contains(Block block) {
        return INTERACT_BEHAVIOURS.containsKey(block.getRegistryName());
    }

    static void register() {
        AllInteractionBehaviours.addInteractionBehaviour(Blocks.f_50164_.getRegistryName(), LeverMovingInteraction::new);
        AllInteractionBehaviours.addInteractionBehaviour(AllBlocks.DEPLOYER.getId(), DeployerMovingInteraction::new);
        for (Block trapdoor : ImmutableList.of((Object)Blocks.f_50220_, (Object)Blocks.f_50216_, (Object)Blocks.f_50221_, (Object)Blocks.f_50217_, (Object)Blocks.f_50219_, (Object)Blocks.f_50218_, (Object)Blocks.f_50664_, (Object)Blocks.f_50663_)) {
            AllInteractionBehaviours.addInteractionBehaviour(trapdoor.getRegistryName(), TrapdoorMovingInteraction::new);
        }
        for (Block door : ImmutableList.of((Object)Blocks.f_50487_, (Object)Blocks.f_50154_, (Object)Blocks.f_50488_, (Object)Blocks.f_50484_, (Object)Blocks.f_50486_, (Object)Blocks.f_50485_, (Object)Blocks.f_50672_, (Object)Blocks.f_50671_)) {
            AllInteractionBehaviours.addInteractionBehaviour(door.getRegistryName(), DoorMovingInteraction::new);
        }
    }
}

