/*
 * Decompiled with CFR 0.152.
 */
package shadows.toaster;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Logger;
import shadows.toaster.BetterToastComponent;
import shadows.toaster.ToastConfig;
import shadows.toaster.ToastLoader;

public class ToastControl {
    public static final String MODID = "toastcontrol";
    public static final Logger LOGGER = ToastLoader.LOGGER;
    public static final KeyMapping CLEAR = new KeyMapping("key.toastcontrol.clear", 74, "key.toastcontrol.category");
    public static final ResourceLocation TRANSLUCENT = new ResourceLocation("toastcontrol", "textures/gui/toasts.png");
    public static final ResourceLocation TRANSPARENT = new ResourceLocation("toastcontrol", "textures/gui/toasts2.png");
    public static final ResourceLocation ORIGINAL = new ResourceLocation("textures/gui/toasts.png");
    public static final List<Class<?>> BLOCKED_CLASSES = new ArrayList();
    public static List<BetterToastComponent.BetterToastInstance<?>> tracker = new ArrayList();

    @SubscribeEvent
    public void keys(InputEvent.KeyInputEvent e) {
        if (CLEAR.m_90857_()) {
            Minecraft.m_91087_().m_91300_().m_94919_();
        }
    }

    public void preInit(FMLClientSetupEvent e) {
        Minecraft.m_91087_().f_91003_ = new BetterToastComponent();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ToastControl.handleToastReloc();
        ToastControl.handleBlockedClasses();
    }

    static void handleToastReloc() {
        ResourceLocation target = Toast.f_94893_;
        if (((Boolean)ToastConfig.INSTANCE.translucent.get()).booleanValue()) {
            ToastControl.change(target, TRANSLUCENT);
        }
        if (((Boolean)ToastConfig.INSTANCE.transparent.get()).booleanValue()) {
            ToastControl.change(target, TRANSPARENT);
        } else if (!((Boolean)ToastConfig.INSTANCE.translucent.get()).booleanValue() && !((Boolean)ToastConfig.INSTANCE.transparent.get()).booleanValue()) {
            ToastControl.change(target, ORIGINAL);
        }
    }

    private static void change(ResourceLocation a, ResourceLocation b) {
        ObfuscationReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.m_135827_(), (String)"f_135804_");
        ObfuscationReflectionHelper.setPrivateValue(ResourceLocation.class, (Object)a, (Object)b.m_135815_(), (String)"f_135805_");
    }

    static void handleBlockedClasses() {
        BLOCKED_CLASSES.clear();
        for (String s : (List)ToastConfig.INSTANCE.blockedClasses.get()) {
            try {
                Class<?> c = Class.forName(s);
                BLOCKED_CLASSES.add(c);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Invalid class string provided to toast control: " + s);
            }
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            for (BetterToastComponent.BetterToastInstance<?> t : tracker) {
                t.tick();
            }
        }
    }
}

