/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.patreon;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import shadows.placebo.patreon.wings.IWingModel;
import shadows.placebo.patreon.wings.Wing;

public class PatreonUtils {
    public static final KeyMapping TOGGLE_T = new KeyMapping("placebo.toggleTrails", 328, "key.categories.placebo");
    public static final KeyMapping TOGGLE_W = new KeyMapping("placebo.toggleWings", 329, "key.categories.placebo");
    public static final ResourceLocation ANGEL_TEX = new ResourceLocation("placebo", "textures/wings/angel.png");
    public static final ResourceLocation BAT_TEX = new ResourceLocation("placebo", "textures/wings/bat.png");
    public static final ResourceLocation DEMON_TEX = new ResourceLocation("placebo", "textures/wings/demon.png");
    public static final ResourceLocation FLY_TEX = new ResourceLocation("placebo", "textures/wings/fly.png");
    public static final ResourceLocation PIXIE_TEX = new ResourceLocation("placebo", "textures/wings/pixie.png");
    public static final ResourceLocation SPOOKY_TEX = new ResourceLocation("placebo", "textures/wings/spooky.png");

    public static enum WingType {
        ANGEL(() -> Wing.INSTANCE, p -> ANGEL_TEX, -0.5),
        BAT(() -> Wing.INSTANCE, p -> BAT_TEX, -0.7),
        DEMON(() -> Wing.INSTANCE, p -> DEMON_TEX, -0.55),
        FLY(() -> Wing.INSTANCE, p -> FLY_TEX, -0.58),
        PIXIE(() -> Wing.INSTANCE, p -> PIXIE_TEX, -0.65),
        SPOOKY(() -> Wing.INSTANCE, p -> SPOOKY_TEX, -0.65);

        public final Supplier<IWingModel> model;
        public final Function<Player, ResourceLocation> textureGetter;
        public final double yOffset;

        private WingType(Supplier<IWingModel> model, Function<Player, ResourceLocation> textureGetter, double yOffset) {
            this.model = model;
            this.textureGetter = textureGetter;
            this.yOffset = yOffset;
        }
    }

    public static enum PatreonParticleType {
        SOUL_FIRE(() -> ParticleTypes.f_123745_),
        FIRE(() -> ParticleTypes.f_123744_),
        CAMPFIRE_SMOKE(() -> ParticleTypes.f_123777_),
        CLOUD(() -> ParticleTypes.f_123796_),
        GROWTH(() -> ParticleTypes.f_123748_),
        DMG_HEART(() -> ParticleTypes.f_123798_),
        HEART(() -> ParticleTypes.f_123750_),
        DRAGON_BREATH(() -> ParticleTypes.f_123799_),
        END_ROD(() -> ParticleTypes.f_123810_),
        FIREWORK(() -> ParticleTypes.f_123815_),
        SLIME(() -> ParticleTypes.f_123753_),
        SNOW(() -> ParticleTypes.f_123754_),
        SOUL(() -> ParticleTypes.f_123746_),
        WITCH(() -> ParticleTypes.f_123771_);

        public final Supplier<ParticleOptions> type;

        private PatreonParticleType(Supplier<ParticleOptions> type) {
            this.type = type;
        }
    }
}

