/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.renderdata;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public abstract class RenderInfo {
    private static final String TANKS_TAG = "tanks";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private static final String ITEM_DISPLAY_TAG = "itemDisplay";
    private static final String UPGRADES_TAG = "upgrades";
    private static final Map<String, UpgradeRenderDataType<?>> RENDER_DATA_TYPES = Map.of(CookingUpgradeRenderData.TYPE.getName(), CookingUpgradeRenderData.TYPE, JukeboxUpgradeRenderData.TYPE.getName(), JukeboxUpgradeRenderData.TYPE);
    private ItemDisplayRenderInfo itemDisplayRenderInfo = new ItemDisplayRenderInfo();
    private final Supplier<Runnable> getSaveHandler;
    private final Map<UpgradeRenderDataType<?>, IUpgradeRenderData> upgradeData = new HashMap();
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;
    private Consumer<RenderInfo> changeListener = ri -> {};

    protected RenderInfo(Supplier<Runnable> getSaveHandler) {
        this.getSaveHandler = getSaveHandler;
    }

    public ItemDisplayRenderInfo getItemDisplayRenderInfo() {
        return this.itemDisplayRenderInfo;
    }

    public <T extends IUpgradeRenderData> void setUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType, T renderData) {
        this.upgradeData.put(upgradeRenderDataType, renderData);
        this.serializeUpgradeData(upgrades -> upgrades.m_128365_(upgradeRenderDataType.getName(), (Tag)renderData.serializeNBT()));
        this.save();
    }

    public <T extends IUpgradeRenderData> Optional<T> getUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType) {
        if (!this.upgradeData.containsKey(upgradeRenderDataType)) {
            return Optional.empty();
        }
        return upgradeRenderDataType.cast(this.upgradeData.get(upgradeRenderDataType));
    }

    private void serializeUpgradeData(Consumer<CompoundTag> modifyUpgradesTag) {
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        CompoundTag upgrades = renderInfo.m_128469_(UPGRADES_TAG);
        modifyUpgradesTag.accept(upgrades);
        renderInfo.m_128365_(UPGRADES_TAG, (Tag)upgrades);
        this.serializeRenderInfo(renderInfo);
    }

    public void setItemDisplayRenderInfo(ItemStack item, int rotation) {
        this.itemDisplayRenderInfo.setItem(item);
        this.itemDisplayRenderInfo.setRotation(rotation);
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.m_128365_(ITEM_DISPLAY_TAG, (Tag)this.itemDisplayRenderInfo.serialize());
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public void setChangeListener(Consumer<RenderInfo> changeListener) {
        this.changeListener = changeListener;
    }

    protected void save(boolean triggerChangeListener) {
        this.getSaveHandler.get().run();
        if (triggerChangeListener) {
            this.changeListener.accept(this);
        }
    }

    protected void save() {
        this.save(false);
    }

    protected abstract void serializeRenderInfo(CompoundTag var1);

    protected void deserialize() {
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            this.deserializeItemDisplay((CompoundTag)renderInfoTag);
            this.deserializeUpgrades((CompoundTag)renderInfoTag);
            this.deserializeTanks((CompoundTag)renderInfoTag);
            this.deserializeBattery((CompoundTag)renderInfoTag);
        });
        this.changeListener.accept(this);
    }

    private void deserializeItemDisplay(CompoundTag renderInfoTag) {
        this.itemDisplayRenderInfo = ItemDisplayRenderInfo.deserialize(renderInfoTag.m_128469_(ITEM_DISPLAY_TAG));
    }

    protected abstract Optional<CompoundTag> getRenderInfoTag();

    public Map<UpgradeRenderDataType<?>, IUpgradeRenderData> getUpgradeRenderData() {
        return this.upgradeData;
    }

    public void removeUpgradeRenderData(UpgradeRenderDataType<?> type) {
        this.upgradeData.remove(type);
        this.serializeUpgradeData(upgrades -> upgrades.m_128473_(type.getName()));
        this.save();
    }

    private void deserializeUpgrades(CompoundTag renderInfoTag) {
        CompoundTag upgrades = renderInfoTag.m_128469_(UPGRADES_TAG);
        upgrades.m_128431_().forEach(key -> {
            if (RENDER_DATA_TYPES.containsKey(key)) {
                UpgradeRenderDataType<?> upgradeRenderDataType = RENDER_DATA_TYPES.get(key);
                this.upgradeData.put(upgradeRenderDataType, (IUpgradeRenderData)upgradeRenderDataType.deserialize(upgrades.m_128469_(key)));
            }
        });
    }

    public CompoundTag getNbt() {
        return this.getRenderInfoTag().orElse(new CompoundTag());
    }

    public void deserializeFrom(CompoundTag renderInfoNbt) {
        this.resetUpgradeInfo(false);
        this.upgradeData.clear();
        this.serializeRenderInfo(renderInfoNbt);
        this.deserialize();
    }

    public void resetUpgradeInfo(boolean triggerChangeListener) {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            renderInfoTag.m_128473_(TANKS_TAG);
            renderInfoTag.m_128473_(BATTERY_TAG);
        });
        this.save(triggerChangeListener);
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks(CompoundTag renderInfoTag) {
        ListTag tanks = renderInfoTag.m_128437_(TANKS_TAG, 10);
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            this.tankRenderInfos.put(TankPosition.valueOf(tank.m_128461_(TANK_POSITION_TAG).toUpperCase(Locale.ENGLISH)), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.m_128469_(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery(CompoundTag renderInfoTag) {
        this.batteryRenderInfo = NBTHelper.getCompound(renderInfoTag, BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        CompoundTag tankInfo = tankRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        ListTag tanks = renderInfo.m_128437_(TANKS_TAG, 10);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.m_128728_(i);
            if (!tank.m_128461_(TANK_POSITION_TAG).equals(tankPosition.m_7912_())) continue;
            tank.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            CompoundTag tankPositionInfo = new CompoundTag();
            tankPositionInfo.m_128359_(TANK_POSITION_TAG, tankPosition.m_7912_());
            tankPositionInfo.m_128365_(TANK_INFO_TAG, (Tag)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.m_128365_(TANKS_TAG, (Tag)tanks);
        }
        this.serializeRenderInfo(renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        CompoundTag batteryInfo = batteryRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.m_128365_(BATTERY_TAG, (Tag)batteryInfo);
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public static class ItemDisplayRenderInfo {
        private static final String ITEM_TAG = "item";
        private static final String ROTATION_TAG = "rotation";
        private ItemStack item;
        private int rotation;

        private ItemDisplayRenderInfo(ItemStack item, int rotation) {
            this.item = item;
            this.rotation = rotation;
        }

        public ItemDisplayRenderInfo() {
            this(ItemStack.f_41583_, 0);
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (!this.item.m_41619_()) {
                ret.m_128365_(ITEM_TAG, (Tag)this.item.serializeNBT());
                ret.m_128405_(ROTATION_TAG, this.rotation);
            }
            return ret;
        }

        private void setItem(ItemStack item) {
            this.item = item;
        }

        public static ItemDisplayRenderInfo deserialize(CompoundTag tag) {
            if (tag.m_128441_(ITEM_TAG)) {
                return new ItemDisplayRenderInfo(ItemStack.m_41712_((CompoundTag)tag.m_128469_(ITEM_TAG)), tag.m_128451_(ROTATION_TAG));
            }
            return new ItemDisplayRenderInfo();
        }

        private void setRotation(int rot) {
            this.rotation = rot;
        }

        public int getRotation() {
            return this.rotation;
        }

        public ItemStack getItem() {
            return this.item;
        }
    }
}

