/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.ArrayList;
import java.util.List;
import net.p3pp3rf1y.sophisticatedcore.api.IIOFilterUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.FilteredItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;

public class InventoryIOHandler {
    private final IItemHandlerSimpleInserter filteredItemHandler;

    public InventoryIOHandler(IStorageWrapper storageWrapper) {
        ArrayList<FilterLogic> inputFilters = new ArrayList<FilterLogic>();
        ArrayList<FilterLogic> outputFilters = new ArrayList<FilterLogic>();
        this.addFilters(storageWrapper, inputFilters, outputFilters);
        IItemHandlerSimpleInserter modifiedInventory = storageWrapper.getInventoryForUpgradeProcessing();
        this.filteredItemHandler = inputFilters.isEmpty() && outputFilters.isEmpty() ? modifiedInventory : new FilteredItemHandler.Modifiable(modifiedInventory, (List<FilterLogic>)inputFilters, (List<FilterLogic>)outputFilters);
    }

    public IItemHandlerSimpleInserter getFilteredItemHandler() {
        return this.filteredItemHandler;
    }

    private void addFilters(IStorageWrapper storageWrapper, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
        List<IIOFilterUpgrade> filterWrappers = storageWrapper.getUpgradeHandler().getWrappersThatImplement(IIOFilterUpgrade.class);
        for (IIOFilterUpgrade wrapper : filterWrappers) {
            wrapper.getInputFilter().ifPresent(inputFilters::add);
            wrapper.getOutputFilter().ifPresent(outputFilters::add);
        }
    }
}

