/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;

public abstract class Tab
extends CompositeWidgetBase<WidgetBase> {
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    public static final int DEFAULT_HEIGHT = 24;
    protected static final int DEFAULT_WIDTH = 21;
    private int width = 21;
    private int height = 24;
    private final List<Component> tooltip;
    private BooleanSupplier shouldShowTooltip = () -> true;
    private BooleanSupplier shouldRender = () -> true;

    protected Tab(Position position, List<Component> tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        super(position, new Dimension(0, 0));
        this.tooltip = tooltip;
        this.addChild(getTabButton.apply(this::onTabIconClicked));
    }

    protected Tab(Position position, Component tooltip, Function<IntConsumer, ButtonBase> getTabButton) {
        this(position, List.of(tooltip), getTabButton);
    }

    public void setHandlers(BooleanSupplier shouldShowTooltip, BooleanSupplier shouldRender) {
        this.shouldShowTooltip = shouldShowTooltip;
        this.shouldRender = shouldRender;
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.shouldRender.getAsBoolean()) {
            return;
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderTooltip(Screen screen, PoseStack poseStack, int mouseX, int mouseY) {
        super.renderTooltip(screen, poseStack, mouseX, mouseY);
        if (this.shouldRender.getAsBoolean() && this.isClosedTooltipVisible(mouseX, mouseY)) {
            screen.m_169388_(poseStack, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Optional<Rect2i> getRectangle() {
        return GuiHelper.getPositiveRectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    protected void renderBg(PoseStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiHelper.GUI_CONTROLS);
        int halfHeight = this.height / 2;
        Tab.m_93133_((PoseStack)matrixStack, (int)this.x, (int)this.y, (float)(256.0f - (float)this.width), (float)0.0f, (int)this.width, (int)halfHeight, (int)256, (int)256);
        Tab.m_93133_((PoseStack)matrixStack, (int)this.x, (int)(this.y + halfHeight), (float)(256.0f - (float)this.width), (float)(256.0f - (float)halfHeight), (int)this.width, (int)halfHeight, (int)256, (int)256);
        this.m_93228_(matrixStack, this.x - 3, this.y, 128, 256 - this.height, 3, this.height);
    }

    protected boolean isClosedTooltipVisible(int mouseX, int mouseY) {
        return this.shouldShowTooltip.getAsBoolean() && this.m_5953_(mouseX, mouseY);
    }

    public int getTopY() {
        return this.y;
    }

    public int getBottomY() {
        return this.y + this.getHeight();
    }

    protected abstract void onTabIconClicked(int var1);

    @Override
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

