/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Color {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^([0-9\\\\.e%]+) *(?:[, ]) *([0-9\\\\.e%]+) *(?:[, ]) *([0-9\\\\.e%]+) *(?:(?:[,/]) *([0-9\\\\.e%]+))?$");
    private final byte r;
    private final byte g;
    private final byte b;
    private final byte a;

    private Color(byte r, byte g, byte b, byte a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public int R() {
        return this.r & 0xFF;
    }

    public int G() {
        return this.g & 0xFF;
    }

    public int B() {
        return this.b & 0xFF;
    }

    public int A() {
        return this.a & 0xFF;
    }

    public String toHex(boolean withHash, boolean alpha) {
        return String.format("%s%02X%02X%02X", withHash ? "#" : "", this.r, this.g, this.b) + (alpha ? String.format("%02X", this.a) : "");
    }

    public String toHex() {
        return this.toHex(true, false);
    }

    public String toHex(boolean alpha) {
        return this.toHex(true, alpha);
    }

    public Color withAlpha(byte alpha) {
        return Color.fromRGB(this.r, this.g, this.b, alpha);
    }

    public int toInt() {
        return ((this.r & 0xFF) << 16) + ((this.g & 0xFF) << 8) + (this.b & 0xFF);
    }

    public int[] toIntArray() {
        return new int[]{this.r & 0xFF, this.g & 0xFF, this.b & 0xFF, this.a & 0xFF};
    }

    public static Color fromString(String color) {
        if ((color = color.trim()).isEmpty()) {
            return null;
        }
        if (color.charAt(0) == '#') {
            return Color.fromHex(color);
        }
        if ((color = color.toLowerCase(Locale.ENGLISH)).charAt(color.length() - 1) == ')' && color.contains("(")) {
            boolean isRGB;
            boolean alpha = false;
            if (color.length() < 10) {
                return null;
            }
            if (color.startsWith("rgb")) {
                isRGB = true;
            } else if (color.startsWith("hsl")) {
                isRGB = false;
            } else {
                return null;
            }
            if (color.charAt(4) == 'a') {
                alpha = true;
            }
            color = color.substring(color.indexOf(40) + 1, color.length() - 1);
            if (isRGB) {
                return Color.fromRGB(color, alpha);
            }
            return Color.fromHSL(color, alpha);
        }
        return null;
    }

    public static Color fromHex(String hex) {
        byte b;
        byte g;
        byte r;
        byte a = 0;
        switch (hex.length()) {
            case 4: 
            case 5: {
                r = (byte)(Integer.parseInt(String.valueOf(hex.charAt(1)), 16) * 17);
                g = (byte)(Integer.parseInt(String.valueOf(hex.charAt(2)), 16) * 17);
                b = (byte)(Integer.parseInt(String.valueOf(hex.charAt(3)), 16) * 17);
                if (hex.length() != 5) break;
                a = (byte)(Integer.parseInt(String.valueOf(hex.charAt(4)), 16) * 17);
                break;
            }
            case 7: 
            case 9: {
                r = (byte)Integer.parseInt(hex.substring(1, 3), 16);
                g = (byte)Integer.parseInt(hex.substring(3, 5), 16);
                b = (byte)Integer.parseInt(hex.substring(5, 7), 16);
                if (hex.length() != 9) break;
                a = (byte)Integer.parseInt(hex.substring(7, 9), 16);
                break;
            }
            default: {
                return null;
            }
        }
        return Color.fromRGB(r, g, b, a);
    }

    public static Color fromRGB(String parameters, boolean alpha) {
        Matcher matcher = PARAMETER_PATTERN.matcher(parameters);
        if (!matcher.matches() || matcher.groupCount() < 3 + (alpha ? 1 : 0)) {
            return null;
        }
        byte a = 0;
        byte r = Color.paramToByte(matcher.group(1));
        byte g = Color.paramToByte(matcher.group(2));
        byte b = Color.paramToByte(matcher.group(3));
        if (alpha) {
            a = Color.paramToByte(matcher.group(4));
        }
        return Color.fromRGB(r, g, b, a);
    }

    public static Color fromRGB(byte r, byte g, byte b) {
        return new Color(r, g, b, -1);
    }

    public static Color fromRGB(byte r, byte g, byte b, byte a) {
        return new Color(r, g, b, a);
    }

    public static Color fromHSL(String parameters, boolean alpha) {
        byte b;
        byte g;
        byte r;
        Matcher matcher = PARAMETER_PATTERN.matcher(parameters);
        if (!matcher.matches() || matcher.groupCount() < 3 + (alpha ? 1 : 0)) {
            return null;
        }
        double h = (byte)Color.paramToDouble(matcher.group(1));
        double s = (byte)Color.paramToDouble(matcher.group(2));
        double l = (byte)Color.paramToDouble(matcher.group(3));
        byte a = 0;
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double x = c * (1.0 - Math.abs(h / 60.0 % 2.0 - 1.0));
        if (h < 60.0) {
            r = (byte)c;
            g = (byte)x;
            b = 0;
        } else if (h < 120.0) {
            r = (byte)x;
            g = (byte)c;
            b = 0;
        } else if (h < 180.0) {
            r = 0;
            g = (byte)c;
            b = (byte)x;
        } else if (h < 240.0) {
            r = 0;
            g = (byte)x;
            b = (byte)c;
        } else if (h < 300.0) {
            r = (byte)x;
            g = 0;
            b = (byte)c;
        } else {
            r = (byte)c;
            g = 0;
            b = (byte)x;
        }
        if (alpha) {
            a = Color.paramToByte(matcher.group(4));
        }
        return Color.fromRGB(r, g, b, a);
    }

    public static double paramToDouble(String param) throws NumberFormatException {
        return Double.parseDouble(param);
    }

    public static byte doubleToByte(double d) {
        if (d < 1.0) {
            d *= 255.0;
        } else if (d > 255.0) {
            d %= 256.0;
        }
        return (byte)d;
    }

    public static byte paramToByte(String param) throws NumberFormatException {
        return Color.doubleToByte(Color.paramToDouble(param));
    }
}

