/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.ObjectDataCenter;
import mcp.mobius.waila.impl.Tooltip;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.RayTracing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TooltipRenderer {
    private final Tooltip tooltip;
    private final boolean showIcon;
    private Vec2 totalSize;
    private float contentHeight;
    IElement icon;

    public TooltipRenderer(Tooltip tooltip, boolean showIcon) {
        WailaTooltipEvent event = new WailaTooltipEvent(tooltip, ObjectDataCenter.get());
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.showIcon = showIcon;
        this.tooltip = tooltip;
        if (showIcon) {
            this.icon = RayTracing.INSTANCE.getIcon();
        }
        this.computeSize();
    }

    public void computeSize() {
        float width = 0.0f;
        float height = 0.0f;
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            width = Math.max(width, size.f_82470_);
            height += size.f_82471_;
        }
        this.contentHeight = height;
        if (this.hasIcon()) {
            Vec2 size = this.icon.getCachedSize();
            width += 12.0f + size.f_82470_;
            height = Math.max(height, size.f_82471_ - 2.0f);
        } else {
            width += 10.0f;
        }
        this.totalSize = new Vec2(width, height += 6.0f);
    }

    public void draw(PoseStack matrixStack) {
        float x = 6.0f;
        float y = 4.0f;
        if (this.hasIcon()) {
            x = this.icon.getCachedSize().f_82470_ + 8.0f;
            if (this.icon.getCachedSize().f_82471_ > this.contentHeight) {
                y += (this.icon.getCachedSize().f_82471_ - this.contentHeight) / 2.0f - 1.0f;
            }
        }
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            line.render(matrixStack, x, y, this.totalSize.f_82470_ - 4.0f, size.f_82471_);
            y += size.f_82471_;
        }
        if (this.tooltip.sneakyDetails) {
            Minecraft mc = Minecraft.m_91087_();
            x = (this.totalSize.f_82470_ - (float)mc.f_91062_.m_92895_("\u25be") + 1.0f) / 2.0f;
            float yOffset = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f;
            if (yOffset > 4.0f) {
                return;
            }
            y = this.totalSize.f_82471_ - 6.0f + yOffset;
            float alpha = 1.0f - Math.abs(yOffset) / 2.0f;
            int alphaChannel = (int)(255.0f * Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
            if (alphaChannel > 4) {
                mc.f_91062_.m_92883_(matrixStack, "\u25be", x, y, 0xFFFFFF | alphaChannel << 24);
            }
        }
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public boolean hasIcon() {
        return this.showIcon && Waila.CONFIG.get().getGeneral().shouldShowIcon() && this.icon != null;
    }

    public Rect2i getPosition() {
        Window window = Minecraft.m_91087_().m_91268_();
        WailaConfig.ConfigOverlay overlay = Waila.CONFIG.get().getOverlay();
        int x = (int)((float)window.m_85445_() * overlay.tryFlip(overlay.getOverlayPosX()));
        int y = (int)((float)window.m_85446_() * (1.0f - overlay.getOverlayPosY()));
        int width = (int)this.totalSize.f_82470_;
        int height = (int)this.totalSize.f_82471_;
        return new Rect2i(x, y, width, height);
    }

    public Vec2 getSize() {
        return this.totalSize;
    }
}

