/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.compat;

import com.mojang.blaze3d.platform.InputConstants;
import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.impl.ObjectDataCenter;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("jade", "main");
    public static KeyMapping showRecipes;
    public static KeyMapping showUses;
    private static IJeiRuntime runtime;
    private static IJeiHelpers helpers;

    public JEICompat() {
        if (showRecipes == null) {
            showRecipes = new KeyMapping("key.waila.show_recipes", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(323), "Jade");
            showUses = new KeyMapping("key.waila.show_uses", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(324), "Jade");
            ClientRegistry.registerKeyBinding((KeyMapping)showRecipes);
            ClientRegistry.registerKeyBinding((KeyMapping)showUses);
            MinecraftForge.EVENT_BUS.addListener(JEICompat::onKeyPressed);
        }
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        helpers = registration.getJeiHelpers();
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        JEICompat.runtime = runtime;
    }

    private static void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (runtime == null || showRecipes == null || showUses == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        if (!showRecipes.m_90857_() && !showUses.m_90857_()) {
            return;
        }
        Accessor<?> accessor = ObjectDataCenter.get();
        if (accessor == null) {
            return;
        }
        ItemStack stack = accessor.getPickedResult();
        if (stack.m_41619_()) {
            return;
        }
        IRecipesGui gui = runtime.getRecipesGui();
        IFocusFactory factory = helpers.getFocusFactory();
        gui.show(factory.createFocus(showUses.m_90857_() ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack));
    }
}

