<!--- hourly processing --->


<cftransaction>

<!--- auction processing --->
<cfquery datasource="#DS#" name="auction">
select * from log_item_auction where expire<#createodbcdatetime(now())#
</cfquery>
<!--- 
u can process successfully multiple queries within a single <cfquery></cfquery> statement. this will reduce the amount of query threads, speeding up processing a lot (especially when there is a lot of queries. however the maximum query 1 single pipe can take is around 400-450 (depends on the data), i put it to 300 <cfif tempqueryx GT 300> just to be safe. basically load the queries in a 2 dimension array (x,y) with names of where an array of up to 300-303 [x] is stored in a tempquery[y] or tempquery[y][x] variable. 

just remember the more query threads you reduce, the more load is reduce. this is by far the code and theory for one of the best CPU optimization from my years of experience, sharing it with you. this idea should work on all platforms (programing language * database)
--->
<cfif auction.recordcount GT 0>
	<!--- first set the 2D array counters and variables, as well the default array tempquery[0] --->
	<cfset tempqueryx = 0> <!--- stores how many queries there is in tempquery[y] --->
	<cfset tempqueryy = 0> <!--- keep track to see how many [y] there is --->
	<cfset tempquery0 = "">
	<cfloop query="auction">
		<cfif tempqueryx GT 300>
			<cfset tempqueryy = tempqueryy+1>
			<cfset "tempquery#tempqueryy#" = "">
		</cfif>
		<cfset point=bid*0.75>
		<cfif point LT cost>
			<cfset point=cost>
		</cfif>

		<!--- this part loads stuff in to the array --->
		<cfset "tempquery#tempqueryy#" = evaluate("tempquery#tempqueryy#") & " update cap set bank=bank+#point# where id=#capid# ">
		<cfset tempqueryx = tempqueryx +1> 

		<cfif parameterexists(capid2) is "YES" and capid2 is not "" and capid2 is not 0>
		
			<!--- this part loads stuff in to the array --->
			<cfset "tempquery#tempqueryy#" = evaluate("tempquery#tempqueryy#") & " insert into cap_item (capid,itemid,cost,type,isize,amount,energy,mod2,mod1) values 			(#session.id#,#itemid#,#cost#,#type#,#isize#,#amount#,#energy#,#mod2#,#mod1#) update cap set bank=bank+#bid#*0.05 where id=(select capid from map_outpost where loc=#loc#) ">
			<cfset tempqueryx = tempqueryx +2>
		
		</cfif>
	</cfloop>
	<cfloop from=0 to=#tempqueryy# index=i> <!--- re-run the array according to the last [y] --->
		<cfquery datasource="#DS#">#evaluate("tempquery#tempqueryy#")#</cfquery> <!--- loads the array and put it in to seperate SQL threads --->
	</cfloop>
	<cfquery datasource="#DS#">delete from log_item_auction where id in (#valuelist(auction.id)#)</cfquery> <!--- a single thread to do mass deletion --->
</cfif>


<!--- refund expired jobs --->
<cfquery datasource="#DS#" name="m">
select capid, member*credit as extracredit from log_m where datetime<#createodbcdatetime(now())#
</cfquery>

<cfif m.recordcount GT 0>
<cfloop from=0 to=#fix(m.recordcount/100)# index=i><cfset "tempquerym#i#" = ""></cfloop>
<cfloop query="m"><cfset i = fix(currentrow/100)>
<cfset "tempquerym#i#" = evaluate("tempquerym#i#")& " update cap set bank = bank+#extracredit# where id = #capid# ">
</cfloop>
<cfloop from=0 to=#fix(m.recordcount/100)# index=i>
<cfif evaluate("tempquerym#i#") is not ""><cfquery datasource="#DS#">#evaluate("tempquerym#i#")#</cfquery></cfif>
</cfloop>
<cfquery datasource="#DS#">delete from log_m where datetime<#createodbcdatetime(now())#</cfquery>
</cfif>

<cfquery datasource="#DS#">
<!--- holo deck--->
delete from cap_holodeck

<!--- construction : outpost ---><Cfset tempdatetime = now()>
update map_outpost set type=8 where type=7 and loc in (select loc from q_outpost where datetime<#tempdatetime#)
delete from q_outpost where datetime<#tempdatetime#
</cfquery>

<cfquery datasource="#DS#">
<!--- factory manufacturing --->
<cfloop from="1" to="12" index="i">
update map_outpost set g#i#_store=g#i#_store+10*g#i#_level where g#i#_store < 50*g#i#_level and g#i#_store is not null
update map_outpost set g#i#_store=50*g#i#_level where g#i#_store > 50*g#i#_level and g#i#_store is not null
</cfloop>

<!--- outpost population related --->
update map_outpost set pop=pop-ceiling(pop*0.01)-1 where (g1<pop or g2<pop or g3<pop or g4<pop or g5<pop) and capid>0
update map_outpost set pop=pop+ceiling(pop*0.02)+1 where (g1>=pop and g2>=pop and g3>=pop and g4>=pop and g5>=pop) and capid>0
update map_outpost set pop=0 where pop<0 and capid>0
update map_outpost set pop=pop2 where pop>pop2 and capid>0
update map_outpost set g1=g1-pop, g2=g2-pop,g3=g3-pop,g4=g4-pop,g5=g5-pop where pop>0
update map_outpost set g1=0 where g1<0
update map_outpost set g2=0 where g2<0
update map_outpost set g3=0 where g3<0
update map_outpost set g4=0 where g4<0
update map_outpost set g5=0 where g5<0
</cfquery>


<!--- mod artifact refresh --->
<cflock name="#APPLICATION.applicationName#_s_loadvar" type="readonly" timeout="5"> 
<cfif parameterexists(application.mod_type_total) is "NO"><cfset runflag=1></cfif>
</cflock>
<cfif parameterexists(runflag)>
<cfquery datasource="#DS#" name="getstuff">
select count(*) as total from cap_mod_type 
</cfquery>
<cflock name="#APPLICATION.applicationName#_s_loadvar" type="Exclusive" timeout="20"> 
<cfset application.mod_type_total = getstuff.total>
</cflock>
</cfif>

<cfquery datasource="#DS#">delete from log_mod</cfquery>
<cfloop from=0 to=10 index=i><cfset "tempquery#i#"=""></cfloop>
<cfscript>
for (l=1;l LTE 999; l = l+1)
{
if ((randrange(1,5) ) is 1)
	i2 = randrange(9,11);
else
	i2 = randrange(1,3);
amount = randrange(10,randrange(10,50))*randrange(1,randrange(1,randrange(2,randrange(7,60))));
if (i2 is 11) amount=amount*5;
"tempquery#fix(l*0.01)#" = evaluate("tempquery#fix(l*0.01)#") & "insert into log_mod (id,type,amount) values (#l#,#i2#,#amount#) ";
}
</cfscript>
<cfloop from=0 to=10 index=i>
<cfif evaluate("tempquery#i#") is not "">
<cfquery datasource="#DS#">
#evaluate("tempquery#i#")#
</cfquery>
</cfif>
</cfloop>

</cftransaction>

<!--- attacking ---><!---
<cfquery datasource="#DS#" name="getattack">
select a.loc
, (select sum(s_weapon) from cap where loc=a.loc and attackflag=1) as a_t 
, (select count(id) from cap where loc=a.loc and attackflag=1) as a_c 

, (select sum(s_weapon) from cap where loc=a.loc and attackflag=2) as d_t 
, (select count(id) from cap where loc=a.loc and attackflag=2) as d_c 

from cap as a where attackflag=1
group by a.loc
</cfquery>

<cfif getattack.recordcount GT 0>

<cfquery datasource="#DS#">
<cfloop query="getattack">
<cfscript>
a_ave = ceiling(a_t/d_c);
d_ave = ceiling(d_t/a_c);
</cfscript>
update cap set s_hull = s_hull - (#a_ave# - s_shield) where s_hull>#a_ave#-s_shield and loc=#loc# and attackflag=1
update cap set s_hull = s_hull - (#a_ave# - s_shield) where s_hull>#a_ave#-s_shield and loc=#loc# and attackflag=2

update cap set s_hull = 0, attackflag=0, loc=#application.gal_center# where s_hull<=#d_ave#-s_shield and loc=#loc# and attackflag=1
update cap set s_hull = 0, attackflag=0, loc=#application.gal_center# where s_hull<=#a_ave#-s_shield and loc=#loc# and attackflag=2
</cfloop>
</cfquery>


<cfscript>
tempquery="";
log1=''; log2='';
</cfscript>
<cfloop query="getattack">
<cfquery datasource="#DS#" name="cap">
select id, attackflag, s_shield,s_hull, s_hull2, name, s_type from cap where loc=#loc# and attackflag>0
</cfquery>
<cfscript>
a_ave = ceiling(a_t/d_c);
d_ave = ceiling(d_t/a_c);
</cfscript>
<cfloop query="cap">

<cfif attackflag is 1><cfset tempdmg = ceiling(evaluate("#randrange(evaluate("#d_ave#*80"),evaluate("#d_ave#*120"))#/100"))>
<cfelseif attackflag is 2><cfset tempdmg = ceiling(evaluate("#randrange(evaluate("#a_ave#*80"),evaluate("#a_ave#*120"))#/100"))>
</cfif>
<cfset temp_hull = s_hull-tempdmg-s_shield>

<cfif temp_hull LT 1>
<cfset tempquery=tempquery&"update cap set s_hull = 0, attackflag=0, loc=#application.gal_center# where id=#id#">
<cfset "log#attackflag#" = evaluate("log#attackflag#")&"<tr align=center><td>#name#</td><td>#evaluate("application.ship_type_#s_type#")#</td><td><b><font color=red>Disabled</font></b></tD><td>#trim(numberformat(s_hull2,'_,_,_,_,_,_,_'))#</td><td>#trim(numberformat(tempdmg,'_,_,_,_,_,_,_'))#</td><tr>">
<cfelse>
<cfset tempquery=tempquery&"update cap set s_hull = #temp_hull# where id=#id#">
<cfset "log#attackflag#" = evaluate("log#attackflag#")&"<tr align=center><td>#name#</td><td>#evaluate("application.ship_type_#s_type#")#</td><td>#trim(numberformat(temp_hull,'_,_,_,_,_,_,_'))#</tD><td>#trim(numberformat(s_hull2,'_,_,_,_,_,_,_'))#</td><td>#trim(numberformat(tempdmg,'_,_,_,_,_,_,_'))#</td><tr>">
</cfif>


</cfloop>
<cfif log2 is not "" and log1 is not "">
<cfset tempquery=tempquery&"
insert into log_attack (loc, attackflag, name) values (#loc#, 1, '#log1#')
insert into log_attack (loc, attackflag, name, datetime) values (#loc#, 2, '#log2#', #createodbcdatetime(now())#)
">
</cfif>
</cfloop>
<cfif tempquery IS NOT "">
<cfquery datasource="#DS#">
#preservesinglequotes(tempquery)#
</cfquery>
</cfif>

</cfif>--->


<cftransaction>

<!--- planet processing --->
<cflock name="#APPLICATION.applicationName#_s_loadvar" type="ReadOnly" timeout="2">
	<cfif parameterexists(application.serverstartflag) and parameterexists(application.NICEHIT_0_TESTHIT_DATETIME)><cfset temp_serverstartflag=1></cfif>
</cflock>

<cfif parameterexists(temp_serverstartflag)>

<cfquery datasource="#DS#">
update map_planet set pop=floor(pop*9/10) where pop>(pop2*2)
update map_planet set tourist=floor(tourist*9/10) where tourist>(tourist2*2)
</cfquery>

<cfscript>query1=""; query2="";</cfscript>

<cfquery datasource="#DS#" name="get">
select loc from map_planet where pop3>pop
</cfquery>

<cfset getlist1 = valuelist(get.loc,",")>
<cfif get.recordcount GT 0>
<cfsavecontent variable = "query1">
<cfoutput>
update cap_planet set s2_p=floor(s2_p*85/100)<cfloop from=3 to=#application.pstype_lastid# index=i>,s#i#_p=floor(s#i#_p*85/100)</cfloop> where loc in (#getlist1#)
update cap_planet set cin=(s0_p*#evaluate("application.pstype_0_cin")#<cfloop from=1 to=#application.pstype_lastid# index=i>+s#i#_p*#evaluate("application.pstype_#i#_cin")#</cfloop> + <cfloop from=0 to=#application.pstype_lastid# index=i>+s#i#_t*#evaluate("application.pstype_#i#_cin")#</cfloop>) ,cout=(s0*#evaluate("application.pstype_0_cout")#<cfloop from=1 to=#application.pstype_lastid# index=i>+s#i#*#evaluate("application.pstype_#i#_cout")#</cfloop>) where loc in (#getlist1#)
update map_planet set pop3=floor(pop3*9/10) where loc in (#getlist1#)
</cfoutput>
</cfsavecontent>
</cfif>

<cfquery datasource="#DS#" name="get">
select loc from map_planet where tourist3>tourist
</cfquery>

<cfset getlist2 = valuelist(get.loc,",")>
<cfif get.recordcount GT 0>
<cfsavecontent variable = "query2">
<cfoutput>
update cap_planet set s2_t=floor(s2_t*85/100)<cfloop from=3 to=#application.pstype_lastid# index=i>,s#i#_t=floor(s#i#_t*85/100)</cfloop> where loc in (#getlist2#)
update cap_planet set cin=(s0_p*#evaluate("application.pstype_0_cin")#<cfloop from=1 to=#application.pstype_lastid# index=i>+s#i#_p*#evaluate("application.pstype_#i#_cin")#</cfloop> + <cfloop from=0 to=#application.pstype_lastid# index=i>+s#i#_t*#evaluate("application.pstype_#i#_cin")#</cfloop>) ,cout=(s0*#evaluate("application.pstype_0_cout")#<cfloop from=1 to=#application.pstype_lastid# index=i>+s#i#*#evaluate("application.pstype_#i#_cout")#</cfloop>) where loc in (#getlist2#)
update map_planet set tourist3=floor(tourist3*9/10) where loc in (#getlist2#)
</cfoutput>
</cfsavecontent>
</cfif>

<cfquery datasource="#DS#">
<cfif query1 is not "" or query2 is not "">
#query1# #query2#
update map_planet set s2_p=isnull((select sum(s2_p) from cap_planet where loc=map_planet.loc),0)<cfloop from=3 to=#application.pstype_lastid# index=i>,s#i#_p=isnull((select sum(s#i#_p) from cap_planet where loc=map_planet.loc),0)</cfloop>, s2_t=isnull((select sum(s2_t) from cap_planet where loc=map_planet.loc),0)<cfloop from=3 to=#application.pstype_lastid# index=i>,s#i#_t=isnull((select sum(s#i#_t) from cap_planet where loc=map_planet.loc),0)</cfloop>, pop3=isnull((select sum(s2_p<cfloop from=3 to=#application.pstype_lastid# index=i>+s#i#_p</cfloop>) from cap_planet where loc=map_planet.loc),0), tourist3=isnull((select sum(s2_t<cfloop from=3 to=#application.pstype_lastid# index=i>+s#i#_t</cfloop>) from cap_planet where loc=map_planet.loc),0)
where loc in (#getlist1#<cfif getlist1 is not "" and getlist2 is not "">,</cfif>#getlist2#)
</cfif>
update cap_planet set bank=bank+(cin-cout) where ( ( bank>=0 and (cin>0 or cout>0) ) or ( bank<0 and cin>cout ) ) and bank<2000000000
update map_planet set pop=1 where pop<=0
update map_planet set tourist=1 where tourist<=0
update map_planet set pop=CEILING(pop*1.02) where pop<pop2+11
update map_planet set tourist=CEILING(tourist*1.02) where tourist<tourist2+11 or (tourist*1.1)<tourist2
</cfquery>

</cfif>

</cftransaction>

<cfoutput>[Hourly stuff processed !]</cfoutput>