<!--- Get rid of any old fleet --->
<cfquery datasource="#DS#">
	DELETE
	FROM ship_user
	WHERE userid = #NPC_ID#
</cfquery>

<cflock name="NPC_#NPC_Server#_WL" type="readonly" timeout="5">
	<cfset NPC_Wins = evaluate("application.NPC_#NPC_ID#_Wins")>
	<cfset NPC_Losses = evaluate("application.NPC_#NPC_ID#_Losses")>
</cflock>

<cfif len(NPC_Wins) lt 1 or NPC_Wins lt 1><cfset NPC_Wins = 1></cfif>
<cfif len(NPC_Losses) lt 1 or NPC_Losses lt 1><cfset NPC_Losses = 1></cfif>

<cfset RandRoll = randrange(1,100)>

<cfif RandRoll gte 1 and RandRoll lte 14>
	<cfset Max_PR_Mod = 1.5>
<cfelseif RandRoll gte 15 and RandRoll lte 50>
	<cfset Max_PR_Mod = 0.75>
<cfelseif RandRoll GTE 51 AND RandRoll LTE 99>
	<cfset Max_PR_Mod = 10>
<cfelse>
	<cfset Max_PR_Mod = 1>
</cfif>

<cfset NPC_FleetMod = 1 + ((100 - ((NPC_Wins / NPC_Losses) * 100)) / 100)>

<cfif NPC_FleetMod lt 1>
	<cfset NPC_FleetMod = 1>
<cfelseif NPC_FleetMod gt 15>
	<cfset NPC_FleetMod = 15>
</cfif>

<cfset NPC_Fleet_New = round(((NPC_FleetMod - 1) * 100) / 1.6)>

<cfset NPC_FleetMod = 1>

<cfif NPC_Fleet_New gt 30>
	<cfset NPC_Fleet_New = 30>
<cfelseif NPC_Fleet_New lt 1>
	<cfset NPC_Fleet_New = 0>
</cfif>

<cflock name="NPC_#NPC_Server#_MaxPR" type="readonly" timeout="5">
	<cfif isDefined("APPLICATION.NPC_#NPC_Server#_Timer")>
		<cfset Max_PR = evaluate("APPLICATION.NPC_#NPC_Server#_MaxPR")>
		<cfset Max_PR_Timer = evaluate("APPLICATION.NPC_#NPC_Server#_Timer")>
	</cfif>
</cflock>

<cfif parameterexists(Max_PR_Timer) is "NO" or DateDiff("n", Max_PR_Timer, now()) gte 0>
	<cfquery datasource="#DS#" name="TopPRFix">
		SELECT id
    FROM `user`
		WHERE server = #NPC_Server# AND power >= 5000 AND nic not like '[NPC%'
		ORDER BY power DESC
		LIMIT 0,5
	</cfquery>
	<cfset TRR1=1>

	<cfquery datasource="#DS#" name="TopPr">
		SELECT power
		FROM `user`
		WHERE server = #NPC_Server# AND power >= 5000 AND nic not like '[NPC%' AND id NOT IN(<cfloop query="TopPRFix">#id#<cfif TRR1 LT TopPRFix.recordcount() AND TopPRFix.recordcount() GTE 2>,</cfif><cfset TRR1=TRR1+1></cfloop><cfif TopPRFix.recordcount() is 0>0</cfif>)
		ORDER BY power DESC
		LIMIT 0,50
	</cfquery>

	<cfset MaxPr = 0>
	<cfloop query="TopPr"><cfset MaxPR = MaxPR + power></cfloop>
	<cfif MaxPR gt 0><cfset MaxPR = (MaxPR / TopPr.recordcount) * 2.5></cfif>

	<!--- NPC PR Cap --->
	<cfif MaxPR gt evaluate("APPLICATION.NPC_#NPC_Server#_MaxPR_Default")><cfset Max_PR = evaluate("APPLICATION.NPC_#NPC_Server#_MaxPR_Default")>
	<cfelseif MaxPR lt evaluate("APPLICATION.NPC_#NPC_Server#_MinPR_Default")><cfset Max_PR = (evaluate("APPLICATION.NPC_#NPC_Server#_MinPR_Default") * 2)>
	<cfelse><cfset Max_PR = MaxPR></cfif>

	<cfset Max_PR = fix(Max_PR)>

	<cflock name="NPC_#NPC_Server#_MaxPR" type="Exclusive" timeout="20">
		<cfset "APPLICATION.NPC_#NPC_Server#_Timer" = DateAdd("n", 120, now())>
		<cfset "APPLICATION.NPC_#NPC_Server#_MaxPR" = Max_PR>
	</cflock>
</cfif>

<cfif NPC_Server gte 0>
	<cfquery datasource="#DS#" name="NPC_Check">
		SELECT power
		FROM `user`
		WHERE server = #NPC_Server# AND power >= 3000000 AND nic like '[NPC%'
		ORDER BY power DESC
		LIMIT 0,5
	</cfquery>

	<cfif NPC_Check.recordcount lte 4>
		<cfset Max_PR_Mod = 9>
	<cfelseif NPC_Check.recordcount gt 4>
		<cfset Max_PR_Mod = 0.35>
	</cfif>
<cfelse>
	<cfquery datasource="#DS#" name="NPC_Check">
		SELECT power
		FROM `user`
		WHERE server = #NPC_Server# AND power >= 1500000 AND nic like '[NPC%'
		ORDER BY power DESC
		LIMIT 0,3
	</cfquery>

	<cfif NPC_Check.recordcount lte 1>
		<cfset Max_PR_Mod = 2>
	<cfelseif NPC_Check.recordcount gte 3>
		<cfset Max_PR_Mod = 0.35>
	</cfif>
</cfif>


<cfquery datasource="#DS#" name="NPC_Check2">
	SELECT power
	FROM `user`
	WHERE server = #NPC_Server# AND power <= 30000 AND nic like '[NPC%'
	ORDER BY power DESC
	LIMIT 0,3
</cfquery>

<!--- Refresh the pr of the NPC to get it's base pr --->
<cfmodule template="../../../s_cal_power.cfm" userid="#NPC_ID#">

<!--- Max PR Mod --->
<cfset Max_PR = ceiling(Max_PR * Max_PR_Mod)>

<!--- Failsafe to ensure it doesn't end up with an impossible roll --->
<cfif NPC_PR lt evaluate("APPLICATION.NPC_#NPC_Server#_MinPR_Default")><cfset NPC_PR = evaluate("APPLICATION.NPC_#NPC_Server#_MinPR_Default")></cfif>
<cfif Max_PR lt ((evaluate("APPLICATION.NPC_#NPC_Server#_MinPR_Default") * NPC_FleetMod) * 4)><cfset Max_PR = (evaluate("APPLICATION.NPC_#NPC_Server#_MinPR_Default") * 4)></cfif>

<!--- Force some down --->
<cfif NPC_Check2.recordcount lte 1><cfset Max_PR = 30000></cfif>

<!--- NPC PR Cap --->
<cfif Max_PR gt evaluate("APPLICATION.NPC_#NPC_Server#_MaxPR_Default")><cfset Max_PR = evaluate("APPLICATION.NPC_#NPC_Server#_MaxPR_Default")></cfif>

<!--- Set the pr for the npc --->
<cfset NPC_PR = randrange(NPC_PR, ceiling(randrange(Max_PR, (Max_PR * 45))))>

<!--- Calculate the amount of stacks it should have --->
<cfif (NPC_PR / (Max_PR / 2)) LTE 0.04>
	<cfset NPC_Stacks = 2>
<cfelseif (NPC_PR / (Max_PR / 2)) GTE 0.04 and (NPC_PR / (Max_PR / 2)) LTE 0.15>
	<cfset NPC_Stacks = 3>
<cfelseif (NPC_PR / (Max_PR / 2)) GT 0.15 and (NPC_PR / (Max_PR / 2)) LTE 0.25>
	<cfset NPC_Stacks = 4>
<cfelseif (NPC_PR / (Max_PR / 2)) GT 0.25 and (NPC_PR / (Max_PR / 2)) LTE 0.39>
	<cfset NPC_Stacks = 5>
<cfelseif (NPC_PR / (Max_PR / 2)) GTE 0.4 and (NPC_PR / (Max_PR / 2)) LTE 0.45>
	<cfset NPC_Stacks = 6>
<cfelseif (NPC_PR / (Max_PR / 2)) GT 0.45 and (NPC_PR / (Max_PR / 2)) LTE 0.5>
	<cfset NPC_Stacks = 7>
<cfelseif (NPC_PR / (Max_PR / 2)) GT 0.5 and (NPC_PR / (Max_PR / 2)) LTE 0.65>
	<cfset NPC_Stacks = 8>
<cfelseif (NPC_PR / (Max_PR / 2)) GT 0.65 and (NPC_PR / (Max_PR / 2)) LTE 0.75>
	<cfset NPC_Stacks = 9>
<cfelse>
	<cfset NPC_Stacks = 10>
</cfif>

<!--- PR for each stack --->
<cfset NPC_PRStack = int(NPC_PR / NPC_Stacks)>


<!--- Neutral Ships --->
<cfset NPC_Ships = ",11,11,13,13,72,72,15,15,15,16,16,73,73,74,74,98,98,98,115,115,189,189,8,8,8,9,190">

<!--- Race Ships --->
<cfif NPC_Race is 1>
	<!--- Terran Ships --->
	<cfset NPC_Ships = NPC_Ships & ",1,1,1,3,3,20,20,4,4,4,21,21,21,21,21,5,5,5,5,22,22,22,22,6,6,23,23,23,23,113,113,113,113,113,14,14,24,24,24,24,24,99,99,99,99,99,25,25,25,100,100,71,71,71,71,71,">
<cfelseif NPC_Race is 6>
	<!--- Miner Ships --->
	<cfset NPC_Ships = NPC_Ships & ",33,33,53,53,53,53,34,34,34,35,35,35,36,36,36,36,68,68,68,68,68,120,120,120,120,120,37,37,37,37,37,101,101,101,101,38,38,38,38,32,32,32,32,32,39,39,39,39,39,40,40,40,40,41,41,102,102,102,70,70,70,70,70,">
<cfelseif NPC_Race is 2>
	<!--- Maru Ships --->
	<cfset NPC_Ships = NPC_Ships & ",26,26,69,69,27,27,27,28,28,28,65,65,65,65,65,29,29,29,29,76,76,76,76,76,103,103,103,103,103,30,30,30,30,66,66,66,66,66,81,81,81,81,31,31,31,31,67,67,67,67,67,114,114,114,114,114,">
<cfelseif NPC_Race is 4>
	<!--- Collective Ships --->
	<cfset NPC_Ships = NPC_Ships & ",1,4,21,21,21,5,5,22,22,23,23,113,113,113,24,24,24,99,99,99,71,71,71,34,35,36,36,68,68,68,37,37,37,101,101,38,38,32,32,32,39,27,28,29,29,76,76,76,103,103,103,30,30,81,81,31,31,116,116,116,116,87,87,87,87,87,88,88,88,88,88,104,104,104,104,104,89,89,89,89,89,90,90,90,90,91,91,91,91,91,105,105,105,105,105,106,106,">
</cfif>

<!--- Finish --->

<cfset NPC_TotalShips = ListLen(NPC_Ships)>
<cfset NPC_DummyStacks = 15 - NPC_Stacks>
<cfset i = 1>

<cfloop condition = "i LESS THAN NPC_Stacks AND NPC_TotalShips gt 0">
	<cfset NPC_Ship_Get = randrange(1,#NPC_TotalShips#)>
	<cfset NPC_ShipID = ListGetAt(NPC_Ships, #NPC_Ship_Get#)>
	<cfset NPC_Ships = replace(NPC_Ships, ",#NPC_ShipID#,", ",", "ALL")>
	<cfset NPC_Ships = replace(NPC_Ships, ",#NPC_ShipID#,", ",", "ALL")>
	<cfset NPC_Ships = replace(NPC_Ships, ",#NPC_ShipID#,", ",", "ALL")>
	<cfset NPC_TotalShips = ListLen(NPC_Ships)>
	<cfset NPC_ShipPR = evaluate("application.s_getvalue_ship_#NPC_ShipID#_power")>
	<cfif NPC_ShipPR lte NPC_PRStack>
		<cfset NPC_ShipAmount = int(NPC_PRStack / evaluate("application.s_getvalue_ship_#NPC_ShipID#_power"))>
		<cfset NPC_PRStack = (NPC_ShipAmount * evaluate("application.s_getvalue_ship_#NPC_ShipID#_power"))>

		<cfquery datasource="#DS#">
			INSERT INTO ship_user
				(userid, type, amount, power)
			VALUES
				(#NPC_ID#, #NPC_ShipID#, #NPC_ShipAmount#, #NPC_PRStack#)
			ON DUPLICATE KEY
			UPDATE amount = amount;
		</cfquery>
		<cfset i = i + 1>
	</cfif>
</cfloop>

<cfloop index="i" from="1" to="#NPC_DummyStacks#">
	<cfif randrange(1,#i#) is 1 or 1 is 1>
		<cfquery datasource="#DS#">
			INSERT INTO ship_user
				(userid, type, amount, power)
			VALUES
				(#NPC_ID#, 7, 1, 5)
			ON DUPLICATE KEY
			UPDATE amount = amount;
		</cfquery>
	</cfif>
</cfloop>

<!--- Invert the Fleet Mod --->
<cfset NPC_FleetMod =  left(NumberFormat((1 / NPC_FleetMod), "9.99"), 3)>
<cfif NPC_FleetMod gt 1.3><cfset NPC_FleetMod = 1.3></cfif>

<cfif parameterexists(NPC_Count) and NPC_Count is 3>
	<cfset dmg = 3>
</cfif>

<!--- Final Update of NPC Pr --->
<cfif parameterexists(dmg) and dmg is 3>
	<cfset Temp_DP = DateAdd("h", (evaluate("application.server#NPC_Server#_dp") * -1), now())>
	<cfset NPC_Protection = DateAdd("n", randrange(evaluate("APPLICATION.NPC_#NPC_Server#_MinDP"),evaluate("APPLICATION.NPC_#NPC_Server#_MaxDP")), Temp_DP)>
	<cfmodule template="../../../s_cal_power.cfm" userid="#NPC_ID#" ExtraSQL = ",planetlost=3,protection=#createodbcdatetime(NPC_Protection)#" FleetMod="#NPC_FleetMod#">
<cfelse>
	<cfmodule template="../../../s_cal_power.cfm" userid="#NPC_ID#" FleetMod="#NPC_FleetMod#" ExtraSQL=",planetlost=0,protection=NULL">
</cfif>
