<cfif !parameterexists(ihasrunflag)><cfoutput>Direct access violation</cfoutput><cfabort></cfif>

<cfscript>
	//Default Project ID
	cfparam(name='ID', default=0);
	cfparam(name='PCreds' default=0);
	cfparam(name='PTurns' default=0);
	cfparam(name="FORM['Turns']" default=0);
	cfparam(name="FORM['Creds']" default=0);
	cfparam(name='Process' default=0);
	cfparam(name='UpdateQuery' default='');
	cfparam(name="Active" default=-1);

	//Page Output
	cfparam(name='PageTitle', default='');
	cfparam(name='PageOut', default='');
	cfparam(name='ActiveDisplay', default='');


	//Load Projects if need be
	if(!parameterexists(SESSION['r_project']))
	{
		UserProjs = queryExecute
			("SELECT r_project
				FROM `user`
				WHERE id=:UserID",
			{
					UserID: SESSION['userid']
			}, {datasource=APPLICATION['DS']});

			SESSION['r_project'] = p['r_project'];
	}

	//ID & Project Validation
	if(URL.KeyExists("id") && len(URL['id']) > 0)
	{
		URL['id'] = ReReplace(URL['id'],"[^0-9,]","","ALL");

		if(len(URL['id']) == 0)
			location url="i.cfm?f=sc_project" addToken="NO";

		ID = (URL['id'] > 0 &&
					ListFind(session.r_project,URL['id'],',') > 0 &&
					isDefined("application.project_#URL['id']#_type") &&
					SESSION['tick'] < now() &&
					SESSION['empirelvl'] > evaluate("application.project_#URL['id']#_reqlevel")) ? URL['id'] : 0;
	}
	else
		location url="i.cfm?f=sc_project" addToken="NO";

	if(ID > 0) //Process Page
	{

		ProjQuery = queryExecute
			("SELECT p.*, u.credit AS UserCredits
			 FROM `user` u
				 INNER JOIN project_user p
				 ON p.userid = :UserID and p.project=:Project
			 WHERE u.id = :UserID",
			{
					UserID: SESSION['userid'],
					Project: ID
			}, {datasource=APPLICATION['DS']});

			if(ProjQuery.RecordCount == 0)
			{
				//Insert Project they should have
				queryExecute
					("INSERT INTO project_user
							(userid, project, credit, turn, activate, finishflag)
								VALUE
							(:UserID, :Project, 0, 0, now(), 0)",
					{
							UserID: SESSION['userid'],
							Project: ID
					}, {datasource=APPLICATION['DS']});

					InstantUsed = 0;
					Active = 0;
					InstantUse  = evaluate("application.project_#URL['id']#_InstantUse");
					ReqActivate = dateadd('h',+evaluate("application.project_#ID#_activate"),now());
			}
			else
				if(len(ProjQuery['activate']) > 0)
					ReqActivate = ProjQuery['activate'];
				else
					ReqActivate = dateadd('h',+evaluate("application.project_#ID#_activate"),now());

			//This is when the project query is found
			if(Active == -1)
			{
				SESSION['credit'] = ProjQuery.UserCredits
				PCreds = ProjQuery['credit'];
				PTurns = ProjQuery['turn'];
				Active = ProjQuery['finishflag'];
				InstantUsed = ProjQuery['InstantUsed'];
				InstantUse = evaluate("application.project_#URL['id']#_InstantUse");
			}
			else;
				//SESSION['credit'] = 0;

			ReqCreds = evaluate("application.project_#ID#_credit") - PCreds;
			ReqTurns = evaluate("application.project_#ID#_turn")   - PTurns;
	}

	if(ID == 0) //Load Project Error Handler
		include 'modules/projects/Error.cfm';
	else
	{
		if(FORM.KeyExists('Update') && Active == 0)
		{
			UseTurns  = ReReplace(FORM['pturn'],"[^0-9,]","","ALL");
			UseCreds  = ReReplace(FORM['pcredit'],"[^0-9,]","","ALL");
			UserTurns = fix(datediff('s',SESSION['tick'],now()) / SESSION['getturnmin']);
			UserCreds = SESSION['credit'];

			//Specific outputs for the user
			if((UseTurns != 0 && !(UseTurns > 0)) ||
				 (UseCreds != 0 && !(UseCreds > 0)))
			 	PageOut &= 'Invalid amount entered';
			else if(UserTurns <= 0 || UserCreds <= 0)
				PageOut &= (UserTurns <= 0 && UserCreds > 0)  ? 'Insufficient Turns' :
									 (UserTurns <= 0 && UserCreds <= 0) ? 'Insufficient Turns & Credits' :
									 (UserCreds <= 0) ? 'Insufficient Credits' : '';
			else //Continue Process
			{
				//Use checks & Cost Checks
				if(UseCreds > UserCreds)      UseCreds = UserCreds;
				if(UseTurns > UserTurns)      UseTurns = UserTurns;
				if((ReqTurns - UseTurns) < 0) UseTurns = ReqTurns;
				if((ReqCreds - UseCreds) < 0) UseCreds = ReqCreds;

				if(UseCreds == ReqCreds && UseTurns == ReqTurns)
					PageOut &= 'You have completed the ' & evaluate("application.en_project_#ID#") & ' Project !';
				else
					PageOut &= 'You have invested in your research into the ' & evaluate("application.en_project_#ID#") & ' Project !';

				SESSION['credits'] = UserCreds -= UseCreds;
				UserTurns -= UseTurns;

				ReqCreds -= UseCreds;
				ReqTurns -= UseTurns;

				UpdateQuery &= " UPDATE project_user
												 SET credit = credit + :UseCreds, turn = turn + :UseTurns";

				if(ReqCreds <= 0 && ReqTurns <= 0)
					UpdateQuery &= ", activate = ':ReqActivate', finishflag = 1";

				UpdateQuery &= " WHERE project = :Project AND userid = :UserID; ";

				if(UseTurns > 0)
					module template="s_endturn.cfm" endturn = UseTurns;

				if(UseCreds > 0)
					UpdateQuery &= " UPDATE `user`
													 SET credit = credit - :UseCreds
													 WHERE id = :UserID;";

				queryExecute(UpdateQuery,
										{ UserID: SESSION['userid'],
											Project: ID,
											UseCreds: UseCreds,
											UseTurns: UseTurns,
											ReqActivate: ReqActivate }, { datasource=APPLICATION['DS'] });
			}
		}

		if(FORM.KeyExists('activate') && (ReqCreds <= 0 && ReqTurns <= 0 && ((datediff("h",now(),ReqActivate) <= 0 || len(ReqActivate) == 0) && Active == 0)))
		{
			queryExecute("UPDATE project_user
										SET finishflag = 1
										WHERE project = :Project AND userid = :UserID;",
									{ UserID: SESSION['userid'],
										Project: ID,
									}, { datasource=APPLICATION['DS'] });

			Active = 1;
		}

		PageTitle &= '<br><span class="ft">Projects > ' &  evaluate("application.en_project_#ID#") & '</span><br><br>
		<table class="tranbox" style="margin-top: 0;" width="75%"><tr class="tranbox2" style="margin-top: 0;" valign="top"><td style="margin-top: 0;" align="center">';


		PageOut &= '<form action="i.cfm?f=sc_project2&amp;id=' & ID & '" method="POST">';

		//Project active conditions
		if(((ReqCreds <= 0 && ReqTurns <= 0) &&
				((len(ReqActivate) == 0) || datediff("h",now(),ReqActivate) <= 0)) &&
			 ((Active == 1) || (InstantUse == 1 && InstantUsed == 0))) //Finished & activated or instant use
		{
			p = ProjQuery;
			savecontent variable="ActiveDisplay" {
 			include "text/p/#ID#.cfm";
			}

			// include "text/p/#ID#.cfm";

		}
		else if(ReqCreds <= 0 && ReqTurns <= 0 && ((datediff("h",now(),ReqActivate) <= 0 || len(ReqActivate) == 0) && Active == 0)) //Finished Can be activated
		{
			PageOut &= '<b>#evaluate("application.en_project_#ID#")#</b>
			<br><span class="fs">#evaluate("application.en_project_#ID#_detail")# </span><br><br><br>
			<div style="font-size: 1.25em; text-align: left; border: 1px solid grey; width: 80%;">Project Completed! <br><br>
			You can choose to activate it now or later:<br>&nbsp;<br>
			<div style="text-align: center;"><input type="submit" value="  Activate Now  " name="activate"><br><br></div></div>';
		}
		else if(ReqCreds <= 0 && ReqTurns <= 0 && datediff("h",now(),ReqActivate) > 0 && Active == 0)
		{
			PageOut &= "<b>#evaluate("application.en_project_#ID#")#</b>
			<br><span class='fs'>#evaluate("application.en_project_#ID#_detail")# </span><br><br><br>";

			PageOut &= "<div style='border: 1px solid grey; width: 70%; text-align: left;'>Project Completed ! <br><br> You can activate this in <span class='tb0' style='font-weight: bold;'>";

			if(datediff("h",now(),ReqActivate) < 2)
				PageOut &= "#datediff("n",now(),ReqActivate)# minutes </div>";
			else
				PageOut &= "#datediff("h",now(),ReqActivate)# hours </div>";
		}
		else if(ReqCreds > 0 || ReqTurns > 0)
		{
			PageOut &= "
			<b>#evaluate("application.en_project_#ID#")#</b>
			<br><span class='fs'>#evaluate("application.en_project_#ID#_detail")# </span><br><br><br>
			<table cellspacing='0' cellpadding='0'><tr><td><table cellspacing='1' cellpadding='1' border='0' width='100%' class='trb'>
			<tr class='tb0' align='center'><td></td><td>Invest</td><td>Left</td></tr>
			<tr class='tb1' align='center'><td width='20%' align='right'>&nbsp;Credit&nbsp;</td><td width='40%'><input type='text' name='pcredit' size='15' onchange='cal();' maxlength='12' value='0'></td><td width='40%'><input type='hidden' name='ocredit' value='#ReqCreds#'><input type='text' name='lcredit' value='#trim(numberformat(ReqCreds,'_,_,_,_,_,_,_,_,_,_,_,_'))#' size='15' onfocus='this.blur();' class='pic'></td></tr>
			<tr class='tb1' align='center'><td align='right'>&nbsp;Turns&nbsp;</td><td><input type='text' name='pturn' size=15 maxlength='2'  onchange='cal();' value='0'></td><td><input type='hidden' name='oturn' value='#ReqTurns#'><input type='text' name='lturn' size='15' value='#trim(numberformat(ReqTurns,'_,_,_,_,_,_,_,_,_,_,_,_'))#' onfocus='this.blur();' class='pic'></td></tr>
			<tr class='tb1'><td></td><Td colspan='2'><input type='submit' value=' Confirm ' name='Update'></td></tr>
			</table></td></tr></table>
			<body onload='cal();'></body>";
		}

		PageOut &= '</form>';

		PageOut &= "<script language='javascript'>
		function formatCurrency(num) {
		num = num.toString().replace(/\$|\,/g,'');
		if(isNaN(num)) num = '0';
		sign = (num == (num = Math.abs(num)));
		num = Math.floor(num*100+0.50000000001);
		num = Math.floor(num/100).toString();
		for (var i = 0; i < Math.floor((num.length-(1+i))/3); i++)
		num = num.substring(0,num.length-(4*i+3))+','+
		num.substring(num.length-(4*i+3));
		return (((sign)?'':'-') + num);
		}

		function cal(element){
		jvar = parseFloat(document.sf.ocredit.value, 10) - parseFloat(document.sf.pcredit.value, 10);
		if ( jvar < 0 ) jvar=0; document.sf.lcredit.value = formatCurrency(jvar);
		jvar = parseFloat(document.sf.oturn.value, 10) - parseFloat(document.sf.pturn.value, 10);
		if ( jvar < 0 ) jvar=0; document.sf.lturn.value = formatCurrency(jvar);
		}
		</script>";

		PageOut &= "<br><br></td></tr></table><br>
		<table width=30% class=tranbox><tr class=tranbox2><td class=fs><font class=cy>Related Help Topics:</font><br>
		<a href=/wiki/?/v/Project_List##project#ID# target=_blank><img src=#idir#b_arrowright.gif>Project Details</a><br>
		</td></tr></table>"
}
</cfscript>

<cfoutput>#PageTitle# <br>#ActiveDisplay# #PageOut#<br><br> </cfoutput>
