<cfif SESSION.KeyExists('Payment-Blacklist') && SESSION['Payment-Blacklist'] == 1>
  <cfoutput>
      Due to previous payment issues your account has been blacklisted from purchasing things in our store. Please contact admin@wrindustries.com if you wish to discuss this.
  </cfoutput>
<cfelse>
  <!--- We expect json from the user, it should be secure enough for now. - BW --->
  <cfparam name="FORM.cart_list" default="">
  <cfset Products = deserializeJSON(FORM.cart_list)>

  <cfif IsArray(Products)>
  	<cfscript>
  		Product[1]['Name'] = '1 Universal Credit';
  		Product[1]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[1]['Price'] = 1.00;
  		Product[1]['Ratio'] = 1.00;
  		Product[1]['SKU'] = 'UC1';

  		Product[2]['Name'] = 'RT 30 Day Premium Account';
  		Product[2]['Desc'] = '30 Days Premium Account Status RT';
  		Product[2]['Price'] = 4.99;
  		Product[2]['Ratio'] = 1.00;
  		Product[2]['SKU'] = 'P30D-RT';

  		Product[3]['Name'] = 'RT 90 Day Premium Account';
  		Product[3]['Desc'] = '90 Days Premium Account Status RT';
  		Product[3]['Price'] = 13.50;
  		Product[3]['Ratio'] = 1.00;
  		Product[3]['SKU'] = 'P90D-RT';

  		Product[4]['Name'] = 'RT 180 Day Premium Account';
  		Product[4]['Desc'] = '180 Days Premium Account Status RT';
  		Product[4]['Price'] = 24.00;
  		Product[4]['Ratio'] = 1.00;
  		Product[4]['SKU'] = 'P180D-RT';

  		Product[5]['Name'] = 'RT 1 Year Premium Account';
  		Product[5]['Desc'] = '1 Year Premium Account Status RT';
  		Product[5]['Price'] = 36.00;
  		Product[5]['Ratio'] = 1.00;
  		Product[5]['SKU'] = 'P1Y-RT';

  		Product[6]['Name'] = 'TB 30 Day Premium Account';
  		Product[6]['Desc'] = '30 Days Premium Account Status TB';
  		Product[6]['Price'] = 3.50;
  		Product[6]['Ratio'] = 1.00;
  		Product[6]['SKU'] = 'P30D-TB';

  		Product[7]['Name'] = 'TB 90 Day Premium Account';
  		Product[7]['Desc'] = '90 Days Premium Account Status TB';
  		Product[7]['Price'] = 9.00;
  		Product[7]['Ratio'] = 1.00;
  		Product[7]['SKU'] = 'P90D-TB';

  		Product[8]['Name'] = 'TB 180 Day Premium Account';
  		Product[8]['Desc'] = '180 Days Premium Account Status TB';
  		Product[8]['Price'] = 15.00;
  		Product[8]['Ratio'] = 1.00;
  		Product[8]['SKU'] = 'P180D-TB';

  		Product[9]['Name'] = 'TB 1 Year Premium Account';
  		Product[9]['Desc'] = '1 Year Premium Account Status TB';
  		Product[9]['Price'] = 24.00;
  		Product[9]['Ratio'] = 1.00;
  		Product[9]['SKU'] = 'P1Y-TB';

  		/* GOLD PACKS NOT IMPLEMENTED YET */

  		Product[10]['Name'] = 'Premium Gold Pack';
  		Product[10]['Desc'] = '30 Days Premium Account Status for one RT and Two Turn-Based Accounts';
  		Product[10]['Price'] = 9.00;
  		Product[10]['Ratio'] = 1.00;
  		Product[10]['SKU'] = 'P30D-G';

  		Product[11]['Name'] = 'Premium Gold Pack';
  		Product[11]['Desc'] = '90 Days Premium Account Status for one RT and Two Turn-Based Accounts';
  		Product[11]['Price'] = 23.50;
  		Product[11]['Ratio'] = 1.00;
  		Product[11]['SKU'] = 'P90D-G';

  		Product[12]['Name'] = 'Premium Gold Pack';
  		Product[12]['Desc'] = '180 Days Premium Account Status for one RT and Two Turn-Based Accounts';
  		Product[12]['Price'] = 35.00;
  		Product[12]['Ratio'] = 1.00;
  		Product[12]['SKU'] = 'P180D-G';

  		Product[13]['Name'] = 'Premium Gold Pack';
  		Product[13]['Desc'] = '1 Year Premium Account Status for one RT and Two Turn-Based Accounts';
  		Product[13]['Price'] = 54.00;
  		Product[13]['Ratio'] = 1.00;
  		Product[13]['SKU'] = 'P1Y-G';

  		Product[14]['Name'] = '3 Universal Credits';
  		Product[14]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[14]['Price'] = 3.00;
  		Product[14]['Ratio'] = 1.00;
  		Product[14]['SKU'] = 'UC3';

  		Product[15]['Name'] = '5 Universal Credits';
  		Product[15]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[15]['Price'] = 5.00;
  		Product[15]['Ratio'] = 1.00;
  		Product[15]['SKU'] = 'UC5';

  		Product[16]['Name'] = '10 Universal Credits';
  		Product[16]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[16]['Price'] = 9.00;
  		Product[16]['Ratio'] = 1.00;
  		Product[16]['SKU'] = 'UC10';

  		Product[17]['Name'] = '20 Universal Credits';
  		Product[17]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[17]['Price'] = 17.50;
  		Product[17]['Ratio'] = 1.00;
  		Product[17]['SKU'] = 'UC20';

  		Product[18]['Name'] = '50 Universal Credits';
  		Product[18]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[18]['Price'] = 40.00;
  		Product[18]['Ratio'] = 1.00;
  		Product[18]['SKU'] = 'UC50';

  		Product[19]['Name'] = '100 Universal Credits';
  		Product[19]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[19]['Price'] = 75.00;
  		Product[19]['Ratio'] = 1.00;
  		Product[19]['SKU'] = 'UC100';

  		Product[20]['Name'] = '250 Universal Credits';
  		Product[20]['Desc'] = 'Universal Credits are used to purchase projects or other goods in the store.';
  		Product[20]['Price'] = 180.00;
  		Product[20]['Ratio'] = 1.00;
  		Product[20]['SKU'] = 'UC250';

  		ProductsAmount = 0;
  		ProductsCost = 0;

  		for(i = 1; i <= 20; i++)
  		{
  			FinishProd[i]['Name'] = Product[i]['Name'];
  			FinishProd[i]['Desc'] = Product[i]['Desc'];
  			FinishProd[i]['SKU'] = Product[i]['SKU'];
  			FinishProd[i]['Amount'] = 0;
  			FinishProd[i]['Cost'] = 0;
  		}
  		ProductsOutput = '';

  		for(i = 1; i <= arrayLen(Products); i++)
  		{
  			ProdQuant = Products[i].KeyExists("product_quantity") ? ReReplace(Products[i]['product_quantity'],"[^0-9,]","","ALL") : 0;
  			ProdID = Products[i].KeyExists("product_id") ? ReReplace(Products[i]['product_id'],"[^0-9,]","","ALL") : 0;

      	if(ProdQuant > 0 && Product[ProdID].KeyExists("Price"))
  			{
  				ProductsCost += Temp = (ProdQuant * (Product[ProdID]['Price'] * Product[ProdID]['Ratio']));

  				FinishProd[ProdID]['Amount'] = ProdQuant;
  				FinishProd[ProdID]['Cost'] += Product[ProdID]['Price'];

  				ProductsAmount += 1;
  				ProductsOutput &= '<tr><td>' & FinishProd[ProdID]['Name'] & '</td><td>' & FinishProd[ProdID]['Amount'] & '</td><td> $' & FinishProd[ProdID]['Cost']*FinishProd[ProdID]['Amount'] & '</td></tr>';
  			}
  			else
  				break;
  		}

  		if(ProductsCost > 0)
  		{
  			BuyStuff = '';


  			for(i = 1; i <= 20; i++)
  				if(FinishProd[i]['Amount'] > 0)
  				{
  					BuyStuff &= '
  					{
  							name: "' & FinishProd[i]['Name'] & '",
  							description: "' & FinishProd[i]['Desc'] & '",
  							sku: "SKU-' & FinishProd[i]['SKU'] & '",
  							unit_amount: {
  									currency_code: "USD",
  									value: "' & FinishProd[i]['Cost'] & '"
  							},
  							quantity: "' & FinishProd[i]['Amount'] & '",
  							category: "DIGITAL_GOODS"
  					},';


  				}


  		}


  	</cfscript>

  	<cfoutput>
  		<table class="Default" style="width: 85%;">
  			<thead><tr class="Header"><td colspan="3">Check Out</td></tr></thead>
  			<tr><td>Name</td><td>Amount</td><td>Total Cost</td></tr>
  			#ProductsOutput#
  			<tr><td colspan="3">&nbsp;</td></tr>
  			<tr style="font-weight: bold;"><td colspan="2">Total Cost</td><td>$ #ProductsCost#</td></tr>
  		</table>

  		<br>
  		<p id="error" class="hidden"><label><input id="check" type="checkbox"> Confirm Your Order</label><br></p>

  		<p id="Wait"></p>

  		<p id="FinalResult"></p>

  		<div id="CheckoutNow" style="margin-top: 3%; font-size: 1.1em;">Check Out Now With:</div>

  		<div id="paypal-button-container" style="margin-top: 1%; width: 33%;"></div>

  		<div class="waitmodal"></div>

  		<script>
  		  paypal.Buttons({
  				style: {
  					color: 'blue',
  					shape: 'pill',
  					size: 'small'
  				},
  				onInit: function(data, actions) {
  					actions.disable();

  					document.querySelector('##check')
  						.addEventListener('change', function(event) {
  							if (event.target.checked) {
  								actions.enable();
  							} else {
  								actions.disable();
  							}
  						});
  				},
  				onClick: function() {
  					if(!document.querySelector('##check').checked) {
  						document.querySelector('##error').classList.remove('hidden');
  					}
  				},
  		    createOrder: function(data, actions) {
  		      return actions.order.create({
  						purchase_units: [
              {
                  description: "Wolfren Industries",
                  amount: {
                      currency_code: "USD",
                      value: "#ProductsCost#",
                      breakdown: {
                          item_total: {
                              currency_code: "USD",
                              value: "#ProductsCost#"
                          }
                      }
                  },
                  items: [ #left(BuyStuff, len(BuyStuff)-1)#
                  ],

              }], application_context: { "client_configuration": {
        																		"integration_artifact": "PAYPAL_JS_SDK",
        																		"experience": {
          																		"user_experience_flow": "FULL_PAGE_REDIRECT",
  																						"entry_point": "PAY_WITH_PAYPAL",
  																						"channel": "WEB",
  																						"product_flow": "HERMES"
  																					}
  																				}, shipping_preference: "NO_SHIPPING",
  																			},
  		      });
  		    },
  		    onApprove: function(data, actions) {
  					$("##error").hide(500);
  					$("##Wait").html('Please Wait...');
  					$("##FinalResult").show(1000);
  					$('##CheckoutNow').hide(500);
  					$('##paypal-button-container').hide(500);
  					// This function captures the funds from the transaction.
  		      return actions.order.capture().then(function(details) {
  						$.ajax({
  							method: "POST",
  							url: "f_com_cart_finalize.cfm",
  							data: {
  											ReqID: details.id
  										},
  							success: function(result) {
  								$("##Wait").hide(500);
  								$("##FinalResult").show(1000);
  								$("##FinalResult").html(result);
  							}
  						})
  		      });
  		    }
  		  }).render('##paypal-button-container');
  		</script>
  	</cfoutput>
  </cfif>
</cfif>
