/** Wolfren Industries
 *  Unification Wars - Classic
 * Copyright (c) 2019
 * Designed by Amadea
 */
component
{
  /* Config Options & Base Info */
  this.AppName = "Edmin - Classic";
  this.Version = 2.0;
  this.ShortName = ListToArray(GetHTTPRequestData()['headers']['host'], '.')[1];
  this.DBDev[0] = 'gcc';
  this.DBDev[1] = 'gccd';
  this.ServerMax = 5;
  this.timeout = 180; //3 Minute Request Timeout
  setting showdebugoutput = "0";

  //Converts Name[]/Name to an array
  this.sameFormFieldsAsArray = 0;
  this.sameURLFieldsAsArray = 1;

  //Client Management
  this.clientManagement = 1;
  this.clientStorage = "memory";
  this.clientTimeout = createTimeSpan(180,0,0,0) //180 Days

  //Cookie Management
  this.setClientCookies = 1;
	this.setDomainCookies = 1;

  //Session Management
  this.sessionManagement = 1;
  this.sessionStorage = "memory";
	this.sessionTimeout = createTimeSpan(0, 0, 30, 0); //30 minutes
  this.sessionType = "cfml";

  //Name of the application itself, which is used for all application calls
  this.name = 'Edmin' & "#this.ShortName#-#this.Version#";

  //Timeout to reload the application data
  this.ApplicationTimeout = CreateTimeSpan(0,12,0,0); //12 hours

  boolean function onRequestStart(string targetPage)
  {
    if(this.ShortName == 'ucc') APPLICATION.Dev = 0;
    else APPLICATION.Dev = 1;

    //Stupid stephen shit.
    Application.ds_uc = this.ShortName;
    Application.ds_gc = this.DBDev[APPLICATION.Dev];
    Application.ds_do = this.DBDev[APPLICATION.Dev];
    Application.ds = Application.ds_uc;

    setting enablecfoutputonly = true;

    if(parameterexists(url.f) && FileExists("Modules\Controllers\#url.f#.cfc"))
      include "Modules\Controllers\#url.f#.cfc";

    return true;
  }

  void function onRequestEnd()
  {

  }


  // void function onError(struct exception, string eventName)
  // {
  //   dump(var:exception,label:eventName);
  // }

  void function onError(struct Error, string eventName)
  {
    this.PageOutput = '<span style="color: red; font-weight:bold;">Message: </span>' &
                       Error.Message & '</span><br><br>';

    for(i=1; ArrayIsDefined(Error.TagContext, i); i++)
      this.PageOutput &= '<h4 style="font-weight: bold; color: red;">Trace ' & i &
                         '<br><span style="font-size: 1.1em; color: white; padding: 0 0;">' &
                         '<br><span style="color: red; font-weight:bold;">Location: </span>' &
                          Error.TagContext[i]['template'] &
                          '<br><span style="color: red; font-weight:bold;">Line: </span>' &
                          Error.TagContext[i]['line'] &
                          '<br><span style="color: red; font-weight:bold;">Raw Trace: </span>' &
                          Error.TagContext[i]['Raw_Trace'] &
                          '</span><br><br>';
    ihasrunflag = 1
    WriteOutput(this.PageOutput);
    //include 'f_com_error.cfm';
  }

  void function onAbort(string targetPage)
  {
    dump("request "&targetPage&" ended with a abort!");
  }

  void function onDebug(struct debuggingData)
  {
    //dump(var:debuggingData,label:"debug information");
  }

  void function onMissingTemplate(string targetPage)
  {
    echo("missing:"&targetPage);
  }
}
