<cfsetting enablecfoutputonly="Yes">
<!---
Developed by Stephen Yong. Updated 2003-04-26
Query Cache ver 3.0

Query Cache : 	caches the query to application variables & arrays. 
				will improve speed to 0 processing

datasource 	= datasource (default using #DS# variable)
name 		= name of the query
maxrow 		= maximum row to be displayed
time		= cache for how long (seconds) (default at 60 seconds)

Example of usage :

<cfoutput>
<cf_querycache datasource="#DS#" name="getdata" maxrows="10">
select * from test 
where name like '%888%'
<cfif parameterexists(url.id)>and id=#url.id#</cfif>
</cf_querycache>
</cfoutput>

--->

<cfparam name="attributes.datasource" default="#caller.ds#"> 
<cfparam name="attributes.time" default="120"> 


<cfif parameterexists(attributes.report)>

<!--- report section --->
<cfif parameterexists(url.killcache)>
<cflock name="#APPLICATION.applicationName#_querycache_qc_l" type="Exclusive" timeout="60" throwontimeout="Yes"> 
<CFLOOP list="#structKeyList(application.qc_l, ",") #" delimiters="," index="i">
<cfset "application.qc_t_#i#" = dateadd("Y",-1,now())>
<!--- #I# - #dateformat(StructFind(application.qc_l, i),'yyyy-mm-dd')# #timeformat(StructFind(application.qc_l, i),'HH:mm')# --->
</cfloop>
<cfset application.qc_l=StructNew()> 
</cflock>
</cfif>
<cfoutput>
<table cellpadding=8 cellspacing=1 class=bodybox><tr><td bgcolor=black align=center>
<b>Query Cache Report</b></td></tr><tr><td align=center>

&nbsp;<br>
<cflock name="#APPLICATION.applicationName#_querycache_qc_l" type="ReadOnly" timeout="30" throwontimeout="Yes">#numberformat(StructCount(application.qc_l),'___,___,___,___,___')#</cflock> active cached query<Br> 
<cfif QUERY_STRING contains "&killcache=1">
<cfset temp2=QUERY_STRING>
<Cfelse>
<cfset temp2="#QUERY_STRING#&killcache=1">
</cfif>
&nbsp;<br>
<a href="#CGI.PATH_INFO#?#temp2#">Clear cache</a><br>&nbsp;
</td></tr></table>
</cfoutput>

<CFelseIF #thistag.generatedcontent# Is NOT ""><CFIF ThisTag.ExecutionMode is 'start'>
<CFELSE>

<cfparam name="rowcount" default="2">
<cfparam name="thistag_generatedcontent" default=""> 

<!--- this section removes empty spaces and <enter> keys --->
<cfloop list="#thistag.generatedcontent#" delimiters="'" index="i">
	<cfif rowcount IS 2>
		<cfscript>
			temp_i=replace(i,chr(13),' ','ALL');
			temp_i=replace(temp_i,chr(10),' ','ALL');
			breakflag=0;
			rowcount=1;
		</cfscript>
		<cfloop condition="breakflag is 0">
			<cfif temp_i contains "  ">
				<cfset temp_i=replace(temp_i,'  ',' ','ALL')>
			<cfelse>
				<Cfset breakflag=1>
			</cfif>
		</cfloop>
		<cfset thistag_generatedcontent="#thistag_generatedcontent##temp_i#">
	<cfelse>
		<cfset thistag_generatedcontent="#thistag_generatedcontent#'#i#'">
		<cfset rowcount=2>
	</cfif>
</cfloop>

<cfscript>
thistag_name = replace(urlencodedformat(thistag_generatedcontent),"%20","","ALL");
thistag_name = replace(urlencodedformat(thistag_name),"%","","ALL");
thistag_name = replace(urlencodedformat(thistag_name),"252","","ALL");
thistag_name = replace(urlencodedformat(thistag_name),"253","","ALL");
thistag_name = replace(urlencodedformat(thistag_name),"255","","ALL");
</cfscript>

<cflock name="#APPLICATION.applicationName#_querycache_qc_#thistag_name#" type="Exclusive" timeout="20" throwontimeout="Yes"> 
<cfif isdefined("application.qc_q_#thistag_name#") IS "NO" or isdefined("application.qc_t_#thistag_name#") IS "NO">
<Cfset QueryFlag=1>
<cfelseif evaluate("application.qc_t_#thistag_name#") LT now()>
<Cfset QueryFlag=1>
<cfelse>
<Cfset QueryFlag=0>
</cfif>
</cflock>

<cfif QueryFlag is 1>

		
	<cfif parameterexists(attributes.maxrows)>
		<cfquery  datasource="#attributes.datasource#" name ="caller.#attributes.name#" maxrows ="#attributes.maxrows#">
			#evaluate("thistag_generatedcontent")#
		</cfquery>
	<cfelse>
		<cfquery  datasource="#attributes.datasource#" name ="caller.#attributes.name#">
		#evaluate("thistag_generatedcontent")#
		</cfquery>
	</cfif>

	<cflock name="#APPLICATION.applicationName#_querycache_qc_#thistag_name#" type="Exclusive" timeout="20" throwontimeout="Yes"> 
	<Cfset "application.qc_q_#thistag_name#" = evaluate("caller.#attributes.name#")>
	<cfset "application.qc_t_#thistag_name#" = dateadd('s',attributes.time,now())>

	<cflock name="#APPLICATION.applicationName#_querycache_qc_l" type="Exclusive" timeout="20" throwontimeout="Yes"> 	
	<cfif isdefined("application.qc_l") IS "NO"><Cfset application.qc_l = StructNew()></cfif>
	<cfif structKeyExists(application.qc_l, thistag_name)>
	<cfset dummy=StructUpdate(application.qc_l, thistag_name, evaluate("application.qc_t_#thistag_name#"))>
	<cfelse>
	<cfset dummy=StructInsert(application.qc_l, thistag_name, evaluate("application.qc_t_#thistag_name#"))>
	</cfif>
	</cflock>

	</cflock>
<cfelse>	
	<cflock name="#APPLICATION.applicationName#_querycache_q_#thistag_name#" type="Exclusive" timeout="20" throwontimeout="Yes"> 
	<cfset "caller.#attributes.name#"=evaluate("application.qc_q_#thistag_name#")>
	<cfif isdefined("application.qc_q_#thistag_name#.recordcount") IS "NO">
	<cfset "caller.#attributes.name#.recordcount" = 0></cfif>
	</cflock>
</cfif>

<cfset thistag.generatedcontent="">

</cfif></cfif>

<cfsetting enablecfoutputonly="no">
