/** Wolfren Industries
 *  Unification Wars - Classic
 * Copyright (c) 2020
 * Designed by Amadea
 */
component
{
  /* Config Options & Base Info */
  this.Version = "1.0";
  this.ShortName = ListToArray(GetHTTPRequestData()['headers']['host'], '.')[1];

  this.timeout = 180; //3 Minute Request Timeout
  setting showdebugoutput = "0";

  //Converts Name[]/Name to an array
  this.sameFormFieldsAsArray = 0;
  this.sameURLFieldsAsArray = 1;

  // Define base location of components & modules
  this.componentpaths = [getDirectoryFromPath(getCurrentTemplatePath()) & "components",
                         getDirectoryFromPath(getCurrentTemplatePath()) & "modules",
                         getDirectoryFromPath(getCurrentTemplatePath()) & "controllers",
                         getDirectoryFromPath(getCurrentTemplatePath()) & "engine"];

  //Client Management
  this.clientManagement = 1;
  this.clientStorage = "memory";
  this.clientTimeout = createTimeSpan(180,0,0,0) //180 Days

  //Cookie Management
  this.setClientCookies = 1;
	this.setDomainCookies = 1;

  //Session Management
  this.sessionManagement = 1;
  this.sessionStorage = "memory";
	this.sessionTimeout = createTimeSpan(0, 0, 30, 0); //30 minutes
  this.sessionType = "cfml";

  //Name of the application itself, which is used for all application calls
  this.name = "#this.ShortName#-#this.Version#";

  //Timeout to reload the application data
  this.ApplicationTimeout = CreateTimeSpan(0,12,0,0); //12 hours

  //Applicaiton start, i.e load everything that's always needed.
  boolean function onApplicationStart()
  {
    structClear(APPLICATION);
    return true;
  }

  void function onApplicationEnd(struct application)
  {

  }

  boolean function onRequestStart(string targetPage)
  {
    //Stupid stephen shit.
    Application.ds_gc = 'g' & right(this.ShortName, 1);
    Application.ds_uc = this.ShortName;
    Application.ds = Application.ds_gc;

    if(!IsDefined("APPLICATION.applicationName"))
      APPLICATION.applicationName = "#this.ShortName#-#this.Version#";

    APPLICATION.DS_GCC = 'g' & mid(this.ShortName,2,9999);
    APPLICATION.DS_UCC = this.ShortName;
    ds = APPLICATION.DS_UCC;
    APPLICATION['DS'] = ds;
    APPLICATION['DS_WRI'] = (right(this.ShortName, 1) == 'd') ? 'WRI_Local' : 'WRI_Live';

    if(right(this.ShortName,1) == 'D')
    {
      APPLICATION.PayPal_Order = "https://api.sandbox.paypal.com/v2/checkout/orders";
      APPLICATION.PayPal_Token = "https://api.sandbox.paypal.com/v1/oauth2/token";
      APPLICATION.PayPal_ClientID = "AcjUA1y7ostyi2VvaDzmL7VRwVP-z6Kxg7MdwqD_xJ1Twn1XbOgfQtw-shazbFNd8iztHRlpCRX1vWMx";
      APPLICATION.PayPal_Secret = "EFPLZEPepbLzdgchorixP_6831iNZorh2V5fPuKhkeusKYMTpPesIR82dMeKWFs3Rj5Jn7FCgaf6MEQm";
    }
    else
    {
      APPLICATION.PayPal_Order = "https://api.paypal.com/v2/checkout/orders";
      APPLICATION.PayPal_Token = "https://api.paypal.com/v1/oauth2/token";
      APPLICATION.PayPal_ClientID = "AdzH1SZl-ErousDMZva6xsBibKNu7hUvvFUkiBve-acSY8fve62qpcpCMw78b-O81cA1qFTylz42z-dB";
      APPLICATION.PayPal_Secret = "EMU3LUYluXVi6cCOPTNlWP5kguYiG_e8R641EZ2RFfnNcqeNgaR5EivQH9MHdfiGya4NDDah7Sg0SZRq";
    }

    setting enablecfoutputonly = true;

    if((empty(url.p) && empty(url.f)) <!---&& (url.p CONTAINS 'login' && url.p != 'logingt' && url.p != 'loginnew' && url.p != '')--->)
      url.p = 'Main';
    if(parameterexists(url.f) && FileExists("modules\controllers\game\#url.f#.cfc"))
      include "modules\controllers\game\#url.f#.cfc";
    else if(parameterexists(url.p) && empty(url.f) && FileExists("modules\controllers\public\#url.p#.cfc"));
      //include "modules\controllers\public\#url.p#.cfc";

    return true;
  }

  void function onRequestEnd()
  {

  }


  // void function onError(struct exception, string eventName)
  // {
  //   dump(var:exception,label:eventName);
  // }

  void function onError(struct Error, string eventName)
  {
    this.PageOutput = '<span style="color: red; font-weight:bold;">Message: </span>' &
                       Error.Message & '</span><br><br>';

    for(i=1; ArrayIsDefined(Error.TagContext, i); i++)
      this.PageOutput &= '<h4 style="font-weight: bold; color: red;">Trace ' & i &
                         '<br><span style="font-size: 1.1em; color: red; padding: 0 0;">' &
                         '<br><span style="color: red; font-weight:bold;">Location: </span>' &
                          Error.TagContext[i]['template'] &
                          '<br><span style="color: red; font-weight:bold;">Line: </span>' &
                          Error.TagContext[i]['line'] &
                          '<br><span style="color: red; font-weight:bold;">Raw Trace: </span>' &
                          Error.TagContext[i]['Raw_Trace'] &
                          '</span><br><br>';
    ihasrunflag = 1
    include 'f_com_error.cfm';
  }

  void function onAbort(string targetPage)
  {
    dump("request "&targetPage&" ended with a abort!");
  }

  void function onDebug(struct debuggingData)
  {
    //dump(var:debuggingData,label:"debug information");
  }

  void function onMissingTemplate(string targetPage)
  {
    echo("missing:"&targetPage);
  }
}
